/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.wamblee.cache.Cache;
import org.wamblee.io.InputResource;

public class EhCache<KeyType extends Serializable, ValueType extends Serializable>
implements Cache<KeyType, ValueType> {
    private static final Logger LOGGER = Logger.getLogger(EhCache.class.getName());
    private CacheManager manager;
    private net.sf.ehcache.Cache cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EhCache(InputResource aResource, String aCacheName) throws IOException, CacheException {
        InputStream is = aResource.getInputStream();
        try {
            this.manager = new CacheManager(is);
            this.cache = this.manager.getCache(aCacheName);
            if (this.cache == null) {
                LOGGER.warning("Creating cache '" + aCacheName + "' because it is not configured");
                this.manager.addCache(aCacheName);
                this.cache = this.manager.getCache(aCacheName);
            }
            assert (this.cache != null);
        }
        finally {
            is.close();
        }
    }

    @Override
    public void put(KeyType aKey, ValueType aValue) {
        this.cache.put(new Element(aKey, aValue));
    }

    @Override
    public ValueType get(KeyType aKey) {
        try {
            Element element = this.cache.get(aKey);
            if (element == null) {
                return null;
            }
            return (ValueType)element.getValue();
        }
        catch (CacheException e) {
            throw new RuntimeException("Cache problem key = '" + aKey + "'", e);
        }
    }

    @Override
    public void remove(KeyType aKey) {
        this.cache.remove(aKey);
    }

    @Override
    public void clear() {
        this.cache.removeAll();
    }
}

