/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.general;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

class SerializableInvocationHandler<T>
implements InvocationHandler,
Serializable {
    private static Map<Integer, Object> STORAGE = new ConcurrentHashMap<Integer, Object>();
    private static AtomicInteger COUNTER = new AtomicInteger();
    private int id = COUNTER.incrementAndGet();
    private Class clazz;

    public SerializableInvocationHandler(T aSvc, Class aClass) {
        this.clazz = aClass;
        STORAGE.put(this.id, aSvc);
    }

    @Override
    public Object invoke(Object aProxy, Method aMethod, Object[] aArgs) throws Throwable {
        Object local = STORAGE.get(this.id);
        try {
            return aMethod.invoke(local, aArgs);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }
}

