/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.wamblee.reflection.Accessor;
import org.wamblee.reflection.FieldAccessor;
import org.wamblee.reflection.PropertyAccessor;
import org.wamblee.reflection.ReflectionUtils;

public class AnnotationUtils {
    public static List<Accessor> analyse(Class aClass, Class<? extends Annotation> aAnnotation) {
        ArrayList<Accessor> result = new ArrayList<Accessor>();
        List<Field> fields = ReflectionUtils.getAllFields(aClass, new Class[0]);
        for (Field field : fields) {
            if (!field.isAnnotationPresent(aAnnotation)) continue;
            result.add(new FieldAccessor(field));
        }
        List<Method> methods = ReflectionUtils.getAllMethods(aClass, Object.class);
        for (Method method : methods) {
            if (!method.isAnnotationPresent(aAnnotation)) continue;
            String setterName = null;
            if (method.getName().startsWith("get")) {
                setterName = method.getName().replaceFirst("get", "set");
            } else if (method.getName().startsWith("is")) {
                setterName = method.getName().replaceFirst("is", "set");
            }
            try {
                Class<?> returnType = method.getReturnType();
                Method setter = method.getDeclaringClass().getDeclaredMethod(setterName, returnType);
                result.add(new PropertyAccessor(method, setter));
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Error obtaining setter for " + method.getName() + " in class " + aClass.getName(), e);
            }
        }
        return result;
    }
}

