/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wamblee.xml.XMLException;
import org.xml.sax.SAXException;

public final class DomUtils {
    private static final Logger LOG = Logger.getLogger(DomUtils.class.getName());

    private DomUtils() {
    }

    public static Document read(String aDocument) throws XMLException {
        ByteArrayInputStream is = new ByteArrayInputStream(aDocument.getBytes());
        return DomUtils.read(is);
    }

    public static Document read(InputStream aIs) throws XMLException {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(aIs);
            return document;
        }
        catch (SAXException e) {
            throw new XMLException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XMLException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new XMLException(e.getMessage(), e);
        }
        finally {
            try {
                aIs.close();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Error closing XML file", e);
            }
        }
    }

    public static Document readAndValidate(InputStream aIs, InputStream aSchema) throws XMLException {
        try {
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(new StreamSource(aSchema));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            factory.setSchema(schema);
            Document document = factory.newDocumentBuilder().parse(aIs);
            return document;
        }
        catch (SAXException e) {
            throw new XMLException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XMLException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new XMLException(e.getMessage(), e);
        }
        finally {
            try {
                aSchema.close();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Error closing schema", e);
            }
            try {
                aIs.close();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Error closing XML file", e);
            }
        }
    }

    public static void serialize(Document aDocument, OutputStream aOs) throws IOException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer identityTransform = factory.newTransformer();
            DOMSource source = new DOMSource(aDocument);
            StreamResult result = new StreamResult(aOs);
            identityTransform.transform(source, result);
        }
        catch (TransformerException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static String serialize(Document aDocument) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DomUtils.serialize(aDocument, os);
        return os.toString();
    }

    public static void removeDuplicateAttributes(Node aNode) {
        NodeList list = aNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            DomUtils.removeDuplicateAttributes((Element)node);
            DomUtils.removeDuplicateAttributes(node);
        }
    }

    private static void removeDuplicateAttributes(Element aElement) {
        NamedNodeMap attributes = aElement.getAttributes();
        TreeMap<String, Attr> uniqueAttributes = new TreeMap<String, Attr>();
        ArrayList<Attr> attlist = new ArrayList<Attr>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if (uniqueAttributes.containsKey(attribute.getNodeName())) {
                LOG.info("Detected duplicate attribute (will be removed)'" + attribute.getNodeName() + "'");
            }
            uniqueAttributes.put(attribute.getNodeName(), attribute);
            attlist.add(attribute);
        }
        for (Attr att : attlist) {
            aElement.removeAttributeNode(att);
        }
        for (Attr att : uniqueAttributes.values()) {
            aElement.setAttributeNode(att);
        }
    }
}

