/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.cache;

import java.io.Serializable;

import java.util.HashMap;

/**
 * A very simple cache based on a HashMap, It never expires any entries, and has
 * no bounds on its size.
 * 
 * @author Erik Brakkee
 * 
 */
public class ForeverCache<KeyType extends Serializable, ValueType extends Serializable>
    implements Cache<KeyType, ValueType> {
    /**
     * Cached entries.
     */
    private HashMap<KeyType, ValueType> map;

    /**
     * Constructs the cache.
     * 
     */
    public ForeverCache() {
        map = new HashMap<KeyType, ValueType>();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wamblee.cache.Cache#put(KeyType, ValueType)
     */
    public synchronized void put(KeyType aKey, ValueType aValue) {
        map.put(aKey, aValue);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wamblee.cache.Cache#get(KeyType)
     */
    public synchronized ValueType get(KeyType aKey) {
        return map.get(aKey);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wamblee.cache.Cache#remove(KeyType)
     */
    public synchronized void remove(KeyType aKey) {
        map.remove(aKey);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.wamblee.cache.Cache#clear()
     */
    public synchronized void clear() {
        map.clear();
    }
}
