/*
 * Copyright 2005-2011 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.general;

/**
 * This class provides a generic typesafe id wrapping a long value.
 * 
 * @author Erik Brakkee
 * 
 * @param <T>
 *            Type the id refers to.
 */
public class Id<T> implements Comparable<Id<T>> {

    private String id;

    /**
     * Constructs the id.
     * 
     * @param aId
     *            Integer id.
     * @throws NullPointerException
     *             in case the id is null.
     */
    public Id(String aId) {
        if (aId == null) {
            throw new NullPointerException("id is null");
        }
        id = aId;
    }

    /**
     * @return The underlying id.
     */
    public String getId() {
        return id;
    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }

    @Override
    public boolean equals(Object aObj) {
        if (aObj == null) {
            return false;
        }
        if (!(aObj instanceof Id)) {
            return false;
        }
        return id.equals(((Id<T>) aObj).id);
    }

    @Override
    public String toString() {
        return id;
    }

    @Override
    public int compareTo(Id<T> aId) {
        return id.compareTo(aId.getId());
    }
}
