/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.general;

/**
 * Object that holds a value of some type. This can be used where a mutable
 * final value would be preferred.
 * 
 * @author Erik Brakkee
 * 
 */
public class ValueHolder<T> {

    private T value;

    /**
     * Constructs with null value.
     */
    public ValueHolder() {
        value = null;
    }

    /**
     * Constructs with given value.
     * 
     * @param aValue
     *            Value.
     */
    public ValueHolder(T aValue) {
        value = aValue;
    }

    /**
     * @return Current value.
     */
    public T getValue() {
        return value;
    }

    /**
     * Set the value.
     * 
     * @param aValue
     *            New value.
     */
    public void setValue(T aValue) {
        value = aValue;
    }
}
