/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.ioc;

/**
 * Bean factory used to obtain objects in a transparent way.
 * 
 * @author Erik Brakkee
 */
public interface BeanFactory {
    /**
     * Finds a bean based on id.
     * 
     * @param aId
     *            Id of the bean.
     * @return Object (always non-null).
     * @throws BeanFactoryException
     *             In case the object could not be found.
     */
    Object find(String aId);

    <T> T find(Class<T> aClass);

    <T> T find(String aId, Class<T> aClass);
}
