/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.persistence;

import java.io.Serializable;

import javax.persistence.EntityManager;

/**
 * Detachable JPA entity.
 * 
 * @author Erik Brakkee
 * 
 * @param <T>
 *            Entity type.
 */
public class JpaDetachable<T> extends AbstractDetachable<T, Serializable> {

    private EntityManager entityManager;
    private Class<T> entityType;

    /**
     * Constructs the detachable.
     * 
     * @param aEntity
     *            Entity.
     */
    public JpaDetachable(EntityManager aEntityManager, T aEntity) {
        super(aEntity);
        entityManager = aEntityManager;
        entityType = (Class<T>) aEntity.getClass();
    }

    /*
     * (non-Javadoc)
     * 
     * @see
     * org.wamblee.persistence.AbstractDetachable#getReference(java.lang.Object)
     */
    protected Serializable getReference(T aObject) {
        Persistent persistent = PersistentFactory.create(aObject);
        return persistent.getPrimaryKey();
    }

    @Override
    protected T load(Serializable aReference) {
        return entityManager.find(entityType, aReference);
    }
}
