/*
 * Copyright 2005-2011 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.xml;

import javax.xml.transform.dom.DOMSource;

/**
 * Generic XML processor. 
 * The XML process may transform the dom tree or it can perform checks on it. 
 * 
 * @author Erik Brakkee
 *
 */
public interface XMLProcessor {

    /**
     * Processes a document. 
     * @param aDocument Document to process. 
     * @return Processed document. 
     * @throws XMLException In case of problems. 
     */
    DOMSource process(DOMSource aDocument) throws XMLException; 
    
}
