/*
 * Copyright 2005-2011 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.xml;

import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;

/**
 * Represents a namespace context and is a factory for creating xpath expressions. 
 * @author Erik Brakkee
 */
public class XPathContext {
    private XPath xpath; 
    
    /**
     * Constructs the context. 
     * @param aContext Namespaces.
     */
    public XPathContext(NamespaceContext aContext) { 
        xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(aContext);
    }
    
    /**
     * Creation of the XPath context for use with static imports. 
     * @param aContext Namespace context
     * @return XPath context.
     */
    public static XPathContext xpathcontext(NamespaceContext aContext) { 
        return new XPathContext(aContext);
    }
    
    /**
     * Creates the expression. 
     * @param aExpression XPath expression. 
     * @return Xpath expression. 
     * @throws XMLException
     */
    public XPathExpression createExpression(String aExpression) throws XMLException { 
        return new XPathExpression(xpath, aExpression);
    }
    
    /**
     * To get access to the lower level API. 
     * @return Lower level API. 
     */
    public XPath getXpath() {
        return xpath;
    }
}
