/*
 * Copyright 2005-2011 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * <p>
 * Utilities for XML processing. The aim of this package is to simplify the 
 * common tasks of parsing, validating, and transforming XML files and to 
 * provide support for XPath. The utlities use the standard Java SE APIs
 * but are much easier to use. For cases where more advanced functionality is required,
 * the classes provide access to the underlying Java SE types. The implementation is 
 * based on DOM level 3 parsing.  
 * </p>
 * 
 * <p>
 * Classes {@link org.wamblee.xml.XMLDocument}, {@link org.wamblee.xml.XMLSchema}, and 
 * {@link org.wamblee.xml.XSLTransformation} provide parsing, validation, and transformation
 * of XML files. The {@link org.wamblee.xml.XMLDocument} class provides various static 
 * methods as entry point for this functionality, simplifying the code a lot when 
 * static imports are used. The API design uses a fluent interfaces style. For instance, 
 * to parse, validate, and transform an XML file, one can write:
 * </p>
 * <pre>
 * import static org.wamblee.xml.XMLDocument.*;
 * ...
 * XMLDocument doc = xmldocument(new File("x.xml").toURI()).validate(new File("x.xsd").toURI()).transform(new File("x.xsl").toURI());
 * </pre>
 * 
 * <p>
 * In addition, a URI resolver {@link org.wamblee.xml.ClasspathUriResolver} is provided to allow resolution of 
 * documents on the classpath. 
 * </p>
 * 
 * <p>
 * For XPath the following classes are provided: 
 * </p>
 * <ul>
 *   <li> {@link org.wamblee.xml.SimpleNamespaceContext}: An generic implementation of {@link javax.xml.namespace.NamespaceContext}.
 *   </li>
 *   <li> {@link org.wamblee.xml.XPathContext}: A factory of <code>XPathExpression</code> objects based on a given namespace
 *     context. 
 *   </li>
 *   <li> {@link org.wamblee.xml.XPathExpression}: The interface for working with XPath. 
 *   </li>
 * </ul>
 * 
 * <p>
 * For instance to apply an XPath expression to an XML document: 
 * </p>
 * <pre>
 *      NamespaceContext context = new XPathContext(new SimpleNamespaceContext()
 *            .addPrefix("n", "http://example.com/1")
 *            .addPrefix("m", "http://example.com/2"));
 *      XMLDocument doc = new XMLDocument(new File("xpathexample.xml").toURI());
 *      String value = context.createExpression("/n:root/m:x").stringEval(doc);
 * </pre>
 * <p>
 * Or, using static imports: 
 * </p>
 *  <pre>
 *      NamespaceContext context = xpathcontext(namespaces()
 *            .addPrefix("n", "http://example.com/1")
 *            .addPrefix("m", "http://example.com/2"));
 *      XMLDocument doc = xmldocument(new File("xpathexample.xml").toURI());
 *      String value = context.createExpression("/n:root/m:x").stringEval(doc);
 * </pre>
 */
package org.wamblee.xml;

