/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.concurrency;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.wamblee.concurrency.ReadLock;
import org.wamblee.concurrency.ReadWriteLockProxyFactory;
import org.wamblee.concurrency.WriteLock;

public class ReadWriteLockProxyFactoryTest {
    private static final int INTERVAL_MILLIS = 10;
    private final Runnable doX = new Runnable(){

        @Override
        public void run() {
            ReadWriteLockProxyFactoryTest.this.proxyX.doX(10);
        }
    };
    private final Runnable doNoLock = new Runnable(){

        @Override
        public void run() {
            ReadWriteLockProxyFactoryTest.this.proxyX.doNoLocking();
        }
    };
    private final Runnable doY = new Runnable(){

        @Override
        public void run() {
            ReadWriteLockProxyFactoryTest.this.proxyY.doY("hello");
        }
    };
    private ReadWriteLockProxyFactory<Z> factory;
    private Z service;
    private X proxyX;
    private Y proxyY;
    private boolean threadFailed;
    private Timer timer;
    private List<Thread> threads;
    private long tstart;

    @Before
    public void setUp() {
        this.factory = new ReadWriteLockProxyFactory();
        this.threadFailed = false;
        this.timer = new Timer();
        this.threads = new ArrayList<Thread>();
    }

    private void startTiming() {
        this.tstart = System.currentTimeMillis();
    }

    private float endTiming() {
        return (float)(System.currentTimeMillis() - this.tstart) / 10.0f;
    }

    private void sleep(int aUnits) {
        try {
            Thread.sleep(aUnits * 10);
        }
        catch (InterruptedException e) {
            this.threadFailed = true;
        }
    }

    private void schedule(final AtomicInteger aUnstartedThreads, final Thread aThread, int aUnits) {
        aUnstartedThreads.incrementAndGet();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                aThread.start();
                aUnstartedThreads.decrementAndGet();
            }
        }, aUnits * 10);
    }

    private void schedule(AtomicInteger aUnstartedThreads, Runnable aTask, int aUnits) {
        Thread t = new Thread(aTask);
        this.schedule(aUnstartedThreads, t, aUnits);
        this.threads.add(t);
    }

    private void join(AtomicInteger aUnstartedThreads, List<Thread> aThreads) {
        while (aUnstartedThreads.get() > 0) {
            this.sleep(1);
        }
        for (Thread t : aThreads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.threadFailed = true;
            }
        }
        Assert.assertFalse((boolean)this.threadFailed);
    }

    private void join(AtomicInteger aUnstartedThreads) {
        this.join(aUnstartedThreads, this.threads);
    }

    private void stubDelays() {
        this.service = new Z(){

            @Override
            @ReadLock
            public void doX(int aValue) {
                ReadWriteLockProxyFactoryTest.this.sleep(10);
            }

            @Override
            @WriteLock
            public void doY(String aValue) {
                ReadWriteLockProxyFactoryTest.this.sleep(10);
            }

            @Override
            public void doNoLocking() {
                ReadWriteLockProxyFactoryTest.this.sleep(10);
            }
        };
        this.createProxy();
        Answer sleep = new Answer(){

            public Object answer(InvocationOnMock aInvocation) throws Throwable {
                ReadWriteLockProxyFactoryTest.this.sleep(10);
                return null;
            }
        };
    }

    @Test
    public void testProxyDelegates() {
        this.service = (Z)Mockito.mock(Z.class);
        this.createProxy();
        Assert.assertTrue((boolean)(this.proxyX instanceof X));
        Assert.assertTrue((boolean)(this.proxyY instanceof Y));
        this.proxyX.doX(10);
        ((Z)Mockito.verify((Object)this.service)).doX(10);
        Mockito.reset((Object[])new Z[]{this.service});
        this.proxyY.doY("hello");
        ((Z)Mockito.verify((Object)this.service)).doY("hello");
        Mockito.reset((Object[])new Z[]{this.service});
    }

    private void createProxy() {
        this.proxyX = (X)this.factory.getProxy((Object)this.service, new Class[]{X.class, Y.class});
        this.proxyY = (Y)((Object)this.proxyX);
    }

    @Test
    public void testConcurrentReadCalls() {
        this.stubDelays();
        this.startTiming();
        int n = 4;
        AtomicInteger unstarted = new AtomicInteger();
        for (int i = 0; i < 4; ++i) {
            this.schedule(unstarted, this.doX, 0);
        }
        this.join(unstarted);
        float duration = this.endTiming();
        Assert.assertTrue((duration < 15.0f ? 1 : 0) != 0);
    }

    @Test
    public void testNoConcurrentWrites() {
        this.stubDelays();
        this.startTiming();
        int n = 2;
        AtomicInteger unstarted = new AtomicInteger();
        for (int i = 0; i < 2; ++i) {
            this.schedule(unstarted, this.doY, 0);
        }
        this.join(unstarted);
        float duration = this.endTiming();
        System.out.println("no concurrent writes: duration " + duration);
        Assert.assertTrue((duration >= 20.0f ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrentWriteAndNoLock() {
        this.stubDelays();
        this.startTiming();
        AtomicInteger unstarted = new AtomicInteger();
        this.schedule(unstarted, this.doY, 0);
        for (int i = 0; i < 10; ++i) {
            this.schedule(unstarted, this.doNoLock, 0);
        }
        this.join(unstarted);
        float duration = this.endTiming();
        System.out.println("concurrent write and no lock: duration: " + duration);
        Assert.assertTrue((duration < 15.0f ? 1 : 0) != 0);
    }

    @Test
    public void testNoConcurrentReadAndWrite() {
        this.stubDelays();
        this.startTiming();
        AtomicInteger unstartedReaders = new AtomicInteger();
        for (int i = 0; i < 4; ++i) {
            this.schedule(unstartedReaders, this.doX, 0);
        }
        List<Thread> readers = this.threads;
        this.threads = new ArrayList<Thread>();
        AtomicInteger unstartedWriters = new AtomicInteger();
        this.schedule(unstartedWriters, this.doY, 5);
        this.join(unstartedReaders, readers);
        float duration = this.endTiming();
        System.out.println("no concurrent read and write: readers duration: " + duration);
        Assert.assertTrue((duration < 15.0f ? 1 : 0) != 0);
        this.join(unstartedWriters, this.threads);
        duration = this.endTiming();
        System.out.println("no concurrent read and write: writer duration: " + duration);
        Assert.assertTrue((duration >= 20.0f && duration <= 25.0f ? 1 : 0) != 0);
    }

    public static interface Z
    extends X,
    Y {
    }

    public static interface Y {
        public void doY(String var1);
    }

    public static interface X {
        public void doX(int var1);

        public void doNoLocking();
    }
}

