/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.concurrency;

import junit.framework.TestCase;
import org.wamblee.concurrency.ReadLocker;
import org.wamblee.concurrency.ReadWriteLock;
import org.wamblee.concurrency.WriteLocker;

public class ReadWriteLockTest
extends TestCase {
    private static final int HALF_SECOND = 100;
    private static final int ONE_SECOND = 200;
    private static final int TWO_SECONDS = 400;
    private ReadWriteLock lock;
    private int nReaders;
    private int nWriters;

    public ReadWriteLockTest(String aName) {
        super(aName);
    }

    private synchronized int getReaderCount() {
        return this.nReaders;
    }

    private synchronized int getWriterCount() {
        return this.nWriters;
    }

    synchronized void incrementReaderCount() {
        ++this.nReaders;
    }

    synchronized void incrementWriterCount() {
        ++this.nWriters;
    }

    synchronized void decrementReaderCount() {
        --this.nReaders;
    }

    synchronized void decrementWriterCount() {
        --this.nWriters;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.lock = new ReadWriteLock();
    }

    protected void tearDown() throws Exception {
        this.lock = null;
        super.tearDown();
    }

    public void testRead() {
        this.lock.acquireRead();
        this.lock.releaseRead();
    }

    public void testWrite() {
        this.lock.acquireWrite();
        this.lock.releaseWrite();
    }

    public void testMultipleReaders() throws InterruptedException {
        ReadLocker runnable = new ReadLocker(this.lock, this, 400);
        Thread t1 = new Thread(runnable);
        t1.start();
        Thread t2 = new Thread(runnable);
        t2.start();
        Thread.sleep(200L);
        ReadWriteLockTest.assertTrue((String)"Not enough readers!", (this.getReaderCount() == 2 ? 1 : 0) != 0);
        t1.join();
        t2.join();
    }

    public void testSingleWriter() throws InterruptedException {
        WriteLocker writer = new WriteLocker(this.lock, this, 200);
        Thread t1 = new Thread(writer);
        Thread t2 = new Thread(writer);
        t1.start();
        t2.start();
        Thread.sleep(100L);
        ReadWriteLockTest.assertTrue((String)("Wrong writer count: " + this.getWriterCount()), (this.getWriterCount() == 1 ? 1 : 0) != 0);
        t1.join();
        t2.join();
    }

    public void testMultipleWriters() throws InterruptedException {
        WriteLocker writer1 = new WriteLocker(this.lock, this, 300);
        WriteLocker writer2 = new WriteLocker(this.lock, this, 200);
        Thread t1 = new Thread(writer1);
        Thread t2 = new Thread(writer2);
        t1.start();
        Thread.sleep(100L);
        ReadWriteLockTest.assertTrue((this.getWriterCount() == 1 ? 1 : 0) != 0);
        t2.start();
        Thread.sleep(100L);
        ReadWriteLockTest.assertTrue((this.getWriterCount() == 1 ? 1 : 0) != 0);
        Thread.sleep(200L);
        ReadWriteLockTest.assertTrue((this.getWriterCount() == 1 ? 1 : 0) != 0);
        t1.join();
        t2.join();
    }

    public void testReadWrite1() throws InterruptedException {
        ReadLocker readLocker = new ReadLocker(this.lock, this, 400);
        Thread t1 = new Thread(readLocker);
        WriteLocker writeLocker = new WriteLocker(this.lock, this, 400);
        Thread t2 = new Thread(writeLocker);
        t1.start();
        Thread.sleep(100L);
        ReadWriteLockTest.assertTrue((this.getReaderCount() == 1 ? 1 : 0) != 0);
        t2.start();
        Thread.sleep(100L);
        ReadWriteLockTest.assertTrue((this.getReaderCount() == 1 ? 1 : 0) != 0);
        ReadWriteLockTest.assertTrue((this.getWriterCount() == 0 ? 1 : 0) != 0);
        Thread.sleep(300L);
        ReadWriteLockTest.assertTrue((String)("Wrong no. of readers: " + this.getReaderCount()), (this.getReaderCount() == 0 ? 1 : 0) != 0);
        ReadWriteLockTest.assertTrue((this.getWriterCount() == 1 ? 1 : 0) != 0);
        t1.join();
        t2.join();
    }

    public void testReadWrite2() throws InterruptedException {
        ReadLocker readLocker1 = new ReadLocker(this.lock, this, 500);
        ReadLocker readLocker2 = new ReadLocker(this.lock, this, 500);
        Thread t1 = new Thread(readLocker1);
        Thread t2 = new Thread(readLocker2);
        WriteLocker writeLocker = new WriteLocker(this.lock, this, 400);
        Thread t3 = new Thread(writeLocker);
        t1.start();
        Thread.sleep(200L);
        ReadWriteLockTest.assertTrue((this.getReaderCount() == 1 ? 1 : 0) != 0);
        t2.start();
        Thread.sleep(100L);
        ReadWriteLockTest.assertTrue((this.getReaderCount() == 2 ? 1 : 0) != 0);
        t3.start();
        Thread.sleep(100L);
        ReadWriteLockTest.assertTrue((this.getReaderCount() == 2 ? 1 : 0) != 0);
        ReadWriteLockTest.assertTrue((this.getWriterCount() == 0 ? 1 : 0) != 0);
        Thread.sleep(200L);
        ReadWriteLockTest.assertTrue((this.getReaderCount() == 1 ? 1 : 0) != 0);
        ReadWriteLockTest.assertTrue((this.getWriterCount() == 0 ? 1 : 0) != 0);
        Thread.sleep(200L);
        ReadWriteLockTest.assertTrue((this.getReaderCount() == 0 ? 1 : 0) != 0);
        ReadWriteLockTest.assertTrue((this.getWriterCount() == 1 ? 1 : 0) != 0);
        t1.join();
        t2.join();
        t3.join();
    }

    public void testReadWrite3() throws InterruptedException {
        ReadLocker readLocker = new ReadLocker(this.lock, this, 400);
        Thread t1 = new Thread(readLocker);
        WriteLocker writeLocker = new WriteLocker(this.lock, this, 400);
        Thread t2 = new Thread(writeLocker);
        t2.start();
        Thread.sleep(100L);
        ReadWriteLockTest.assertTrue((this.getWriterCount() == 1 ? 1 : 0) != 0);
        t1.start();
        Thread.sleep(100L);
        ReadWriteLockTest.assertTrue((this.getWriterCount() == 1 ? 1 : 0) != 0);
        ReadWriteLockTest.assertTrue((this.getReaderCount() == 0 ? 1 : 0) != 0);
        Thread.sleep(300L);
        ReadWriteLockTest.assertTrue((String)("Wrong no. of writers: " + this.getReaderCount()), (this.getWriterCount() == 0 ? 1 : 0) != 0);
        ReadWriteLockTest.assertTrue((this.getReaderCount() == 1 ? 1 : 0) != 0);
        t1.join();
        t2.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReleaseReadFromWrongThread() throws InterruptedException {
        Thread t1 = null;
        try {
            t1 = new Thread(new Runnable(){

                @Override
                public void run() {
                    ReadWriteLockTest.this.lock.acquireRead();
                }
            });
            t1.start();
            Thread.sleep(200L);
            this.lock.releaseRead();
        }
        catch (RuntimeException e) {
            return;
        }
        finally {
            t1.join();
        }
        ReadWriteLockTest.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReleaseWriteFromWrongThread() throws InterruptedException {
        Thread t1 = null;
        try {
            t1 = new Thread(new Runnable(){

                @Override
                public void run() {
                    ReadWriteLockTest.this.lock.acquireWrite();
                }
            });
            t1.start();
            Thread.sleep(200L);
            this.lock.releaseWrite();
        }
        catch (RuntimeException e) {
            return;
        }
        finally {
            t1.join();
        }
        ReadWriteLockTest.fail();
    }

    public void testAcquireReadTwice() {
        try {
            this.lock.acquireRead();
            this.lock.acquireRead();
        }
        catch (RuntimeException e) {
            return;
        }
        ReadWriteLockTest.fail();
    }

    public void testAcquireWriteTwice() {
        try {
            this.lock.acquireWrite();
            this.lock.acquireWrite();
        }
        catch (RuntimeException e) {
            return;
        }
        ReadWriteLockTest.fail();
    }

    public void testAcquireReadFollowedByWrite() {
        try {
            this.lock.acquireRead();
            this.lock.acquireWrite();
        }
        catch (RuntimeException e) {
            return;
        }
        ReadWriteLockTest.fail();
    }

    public void testAcquireWriteFollowedByRead() {
        try {
            this.lock.acquireWrite();
            this.lock.acquireRead();
        }
        catch (RuntimeException e) {
            return;
        }
        ReadWriteLockTest.fail();
    }

    public void testAcquireReadFollowedByReleaseaWrite() {
        try {
            this.lock.acquireRead();
            this.lock.releaseWrite();
        }
        catch (RuntimeException e) {
            return;
        }
        ReadWriteLockTest.fail();
    }

    public void testAcquireWriteFollowedByReleaseRead() {
        try {
            this.lock.acquireWrite();
            this.lock.releaseRead();
        }
        catch (RuntimeException e) {
            return;
        }
        ReadWriteLockTest.fail();
    }
}

