/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class EventTracker<Event> {
    private static final Logger LOG = Logger.getLogger(EventTracker.class.getName());
    private Map<Thread, List<Event>> events;

    public EventTracker() {
        this.clear();
    }

    public synchronized void clear() {
        this.events = new HashMap<Thread, List<Event>>();
    }

    public synchronized void eventOccurred(Event aEvent) {
        LOG.info("Event '" + aEvent + "' sent.");
        Thread current = Thread.currentThread();
        List<Event> eventList = this.events.get(current);
        if (eventList == null) {
            eventList = new ArrayList<Event>();
            this.events.put(current, eventList);
        }
        eventList.add(aEvent);
    }

    public synchronized boolean isEventSent(Thread aThread, Event aEvent) {
        List<Event> eventList = this.events.get(aThread);
        if (eventList == null) {
            return false;
        }
        return eventList.contains(aEvent);
    }

    public synchronized List<Event> getEvents(Thread aThread) {
        List<Object> eventList = this.events.get(aThread);
        if (eventList == null) {
            eventList = Collections.emptyList();
        }
        return Collections.unmodifiableList(eventList);
    }

    public synchronized int getEventCount(Event aEvent) {
        int count = 0;
        for (Thread thread : this.events.keySet()) {
            List<Event> eventList = this.events.get(thread);
            for (Event event : eventList) {
                if (!event.equals(aEvent)) continue;
                ++count;
            }
        }
        return count;
    }

    public synchronized int getEventCount() {
        int count = 0;
        for (Thread thread : this.events.keySet()) {
            count += this.events.get(thread).size();
        }
        return count;
    }
}

