/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.xml;

import java.io.IOException;
import javax.xml.transform.TransformerException;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.ls.LSInput;
import org.wamblee.io.ClassPathResource;
import org.wamblee.io.FileSystemUtils;
import org.wamblee.xml.ClasspathUriResolver;

public class ClasspathUriResolverTest {
    private static final String REPORT_TO_HTML_XSL = "reportToHtml.xsl";
    private static final String PREFIX = "org/wamblee/xml";
    private static final String EXISTING_RESOURCE = "org/wamblee/xml/reportToHtml.xsl";
    private static final String NON_EXISTING_RESOURCE = "org/wamblee/xml/reportToHtml-nonexisting.xsl";
    private ClasspathUriResolver resolver;

    @Before
    public void setUp() throws Exception {
        this.resolver = new ClasspathUriResolver();
    }

    @Test
    public void testResolveNonExistingFileURIResolver() {
        try {
            this.resolver.resolve(NON_EXISTING_RESOURCE, "");
        }
        catch (TransformerException e) {
            return;
        }
        TestCase.fail();
    }

    @Test
    public void testResolveExistingFileLSResourceResolver() throws TransformerException, IOException {
        LSInput source = this.resolver.resolveResource(null, null, "kees", EXISTING_RESOURCE, null);
        TestCase.assertNotNull((Object)source);
        TestCase.assertEquals((String)"kees", (String)source.getPublicId());
        TestCase.assertEquals((String)EXISTING_RESOURCE, (String)source.getSystemId());
        String resolved = FileSystemUtils.read(source.getByteStream());
        ClassPathResource resource = new ClassPathResource(EXISTING_RESOURCE);
        String expected = FileSystemUtils.read(resource.getInputStream());
        TestCase.assertEquals((String)expected, (String)resolved);
    }

    @Test
    public void testResolveExistingFileLSResourceResolverUsingBasePath() throws TransformerException, IOException {
        this.resolver = new ClasspathUriResolver(PREFIX);
        LSInput source = this.resolver.resolveResource(null, null, "kees", REPORT_TO_HTML_XSL, null);
        TestCase.assertNotNull((Object)source);
        TestCase.assertEquals((String)"kees", (String)source.getPublicId());
        TestCase.assertEquals((String)REPORT_TO_HTML_XSL, (String)source.getSystemId());
        String resolved = FileSystemUtils.read(source.getByteStream());
        ClassPathResource resource = new ClassPathResource(EXISTING_RESOURCE);
        String expected = FileSystemUtils.read(resource.getInputStream());
        TestCase.assertEquals((String)expected, (String)resolved);
    }

    @Test
    public void testResolveNonExistingFileLSResourceResolver() {
        LSInput input = this.resolver.resolveResource(null, null, "kees", NON_EXISTING_RESOURCE, null);
        TestCase.assertNull((Object)input);
    }
}

