/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import junit.framework.Assert;
import org.junit.Test;
import org.wamblee.xml.SimpleNamespaceContext;

public class SimpleNamespaceContextTest {
    private List<String> toList(Iterator aIterator) {
        ArrayList<String> result = new ArrayList<String>();
        while (aIterator.hasNext()) {
            result.add((String)aIterator.next());
        }
        return result;
    }

    @Test
    public void testDefaultContextNoNamespace() {
        SimpleNamespaceContext context = SimpleNamespaceContext.namespaceContext();
        Assert.assertEquals((String)"", (String)context.getNamespaceURI(""));
        Assert.assertEquals((String)"", (String)context.getNamespaceURI("xxx"));
        Assert.assertEquals((String)"http://www.w3.org/XML/1998/namespace", (String)context.getNamespaceURI("xml"));
        Assert.assertEquals((String)"http://www.w3.org/2000/xmlns/", (String)context.getNamespaceURI("xmlns"));
        Assert.assertNull((Object)context.getPrefix(""));
        Assert.assertFalse((boolean)context.getPrefixes("").hasNext());
        Assert.assertEquals((String)"xml", (String)context.getPrefix("http://www.w3.org/XML/1998/namespace"));
        Assert.assertEquals(Arrays.asList("xml"), this.toList(context.getPrefixes("http://www.w3.org/XML/1998/namespace")));
        Assert.assertEquals((String)"xmlns", (String)context.getPrefix("http://www.w3.org/2000/xmlns/"));
        Assert.assertEquals(Arrays.asList("xmlns"), this.toList(context.getPrefixes("http://www.w3.org/2000/xmlns/")));
        Assert.assertNull((Object)context.getPrefix("http://something.com"));
        Assert.assertFalse((boolean)context.getPrefixes("http://something.com").hasNext());
    }

    @Test
    public void testSinglePrefix() {
        SimpleNamespaceContext context = SimpleNamespaceContext.namespaceContext((String)"aaa", (String)"http://example.com");
        this.singlePrefixAssertions((NamespaceContext)context);
    }

    private void singlePrefixAssertions(NamespaceContext context) {
        Assert.assertEquals((String)"", (String)context.getNamespaceURI(""));
        Assert.assertEquals((String)"", (String)context.getNamespaceURI("xxx"));
        Assert.assertEquals((String)"http://example.com", (String)context.getNamespaceURI("aaa"));
        Assert.assertEquals((String)"http://www.w3.org/XML/1998/namespace", (String)context.getNamespaceURI("xml"));
        Assert.assertEquals((String)"http://www.w3.org/2000/xmlns/", (String)context.getNamespaceURI("xmlns"));
        Assert.assertNull((Object)context.getPrefix(""));
        Assert.assertEquals((String)"xml", (String)context.getPrefix("http://www.w3.org/XML/1998/namespace"));
        Assert.assertEquals((String)"xmlns", (String)context.getPrefix("http://www.w3.org/2000/xmlns/"));
        Assert.assertNull((Object)context.getPrefix("http://something.com"));
        Assert.assertEquals((String)"aaa", (String)context.getPrefix("http://example.com"));
    }

    @Test
    public void testMultiplePrefixes() {
        SimpleNamespaceContext context = SimpleNamespaceContext.namespaceContext().addPrefix("aaa", "http://example.com").addPrefix("bbb", "http://example.com").addPrefix("ccc", "http://example2.com").addPrefix("ddd", "http://www.w3.org/XML/1998/namespace").addPrefix("eee", "http://www.w3.org/2000/xmlns/");
        this.singlePrefixAssertions((NamespaceContext)context);
        List<String> prefixes = this.toList(context.getPrefixes("http://example.com"));
        Assert.assertEquals((int)2, (int)prefixes.size());
        Assert.assertTrue((boolean)prefixes.contains("aaa"));
        Assert.assertTrue((boolean)prefixes.contains("bbb"));
        prefixes = this.toList(context.getPrefixes("http://example2.com"));
        Assert.assertEquals((int)1, (int)prefixes.size());
        Assert.assertTrue((boolean)prefixes.contains("ccc"));
        prefixes = this.toList(context.getPrefixes("http://www.w3.org/XML/1998/namespace"));
        Assert.assertEquals((int)1, (int)prefixes.size());
        Assert.assertTrue((boolean)prefixes.contains("xml"));
        prefixes = this.toList(context.getPrefixes("http://www.w3.org/2000/xmlns/"));
        Assert.assertEquals((int)1, (int)prefixes.size());
        Assert.assertTrue((boolean)prefixes.contains("xmlns"));
    }
}

