/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.TestCase;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.LSResourceResolver;
import org.wamblee.xml.ClasspathUriResolver;
import org.wamblee.xml.XMLDocument;
import org.wamblee.xml.XMLException;
import org.wamblee.xml.XmlUtils;

public class XMLSchemaTest {
    private URI getResourceUri(String aResource) throws URISyntaxException {
        return this.getClass().getResource(aResource).toURI();
    }

    private InputStream getResource(String aResource) {
        return this.getClass().getResourceAsStream(aResource);
    }

    @Test
    public void testReadAndValidateOkUseUri() throws Exception {
        XMLDocument xmldoc = XMLDocument.xmldocument((String)"test.xml", (InputStream)this.getResource("test.xml")).validate(this.getResourceUri("test.xsd"));
        Document doc = xmldoc.getDocument();
        Element element = doc.getDocumentElement();
        TestCase.assertEquals((String)"http://wamblee.org/test", (String)element.getNamespaceURI());
        String val = xmldoc.print(false);
        Document doc2 = XMLDocument.xmldocument((String)"input.xml", (InputStream)new ByteArrayInputStream(val.getBytes())).getDocument();
        XmlUtils.assertEquals("", doc, doc2);
    }

    @Test
    public void testReadAndValidateOkUseClasspath() throws Exception {
        XMLDocument xmldoc = XMLDocument.xmldocument((String)"test.xml", (InputStream)this.getResource("test.xml")).validate("test.xsd", (LSResourceResolver)new ClasspathUriResolver("org/wamblee/xml"));
        Document doc = xmldoc.getDocument();
        Element element = doc.getDocumentElement();
        TestCase.assertEquals((String)"http://wamblee.org/test", (String)element.getNamespaceURI());
        String val = xmldoc.print(false);
        Document doc2 = XMLDocument.xmldocument((String)"input.xml", (InputStream)new ByteArrayInputStream(val.getBytes())).getDocument();
        XmlUtils.assertEquals("", doc, doc2);
    }

    @Test(expected=XMLException.class)
    public void testSchemaNotFoundUseClasspath() throws Exception {
        XMLDocument xmldoc = XMLDocument.xmldocument((String)"test.xml", (InputStream)this.getResource("test.xml")).validate("test.xsd.unknown", (LSResourceResolver)new ClasspathUriResolver("org/wamblee/xml"));
    }

    @Test(expected=XMLException.class)
    public void testReadAndValidateNotOk() throws Exception {
        XMLDocument xmldoc = XMLDocument.xmldocument((String)"testInvalid.xml", (InputStream)this.getResource("testInvalid.xml")).validate(this.getResourceUri("test.xsd"));
    }
}

