/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.xml;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.NamespaceContext;
import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wamblee.xml.SimpleNamespaceContext;
import org.wamblee.xml.XMLDocument;
import org.wamblee.xml.XMLException;
import org.wamblee.xml.XPathContext;

public class XPathExpressionTest {
    private XPathContext context;
    private XMLDocument doc;

    @Before
    public void setUp() throws XMLException, URISyntaxException, IOException {
        this.context = XPathContext.xpathcontext((NamespaceContext)SimpleNamespaceContext.namespaces().addPrefix("n", "http://example.com/1").addPrefix("m", "http://example.com/2"));
        this.doc = XMLDocument.xmldocument((URI)this.getClass().getResource("xpathexample.xml").toURI());
    }

    @Test(expected=XMLException.class)
    public void testInvalidXpath() throws XMLException {
        this.context.createExpression("a[");
    }

    @Test
    public void testStringVal() throws XMLException {
        String value = this.context.createExpression("/n:root/m:x").stringEval(this.doc);
        TestCase.assertEquals((String)"hallo", (String)value.trim());
    }

    @Test
    public void testBooleanVal() throws XMLException {
        TestCase.assertTrue((boolean)this.context.createExpression("/n:root/m:x").booleanEval(this.doc));
        TestCase.assertFalse((boolean)this.context.createExpression("unknownelement").booleanEval(this.doc));
    }

    @Test
    public void testNummberVal() throws XMLException {
        TestCase.assertEquals((Object)1.0, (Object)this.context.createExpression("count(/n:root/m:x)").numberEval(this.doc));
        TestCase.assertEquals((Object)11.0, (Object)this.context.createExpression("//n:elem").numberEval(this.doc));
    }

    @Test
    public void testNodeVal() throws XMLException {
        Node node = this.context.createExpression("/n:root/n:elem").nodeEval(this.doc);
        TestCase.assertTrue((boolean)(node instanceof Element));
        TestCase.assertEquals((String)"11", (String)node.getTextContent().trim());
        TestCase.assertEquals((String)"elem", (String)node.getLocalName());
        TestCase.assertEquals((String)"http://example.com/1", (String)node.getNamespaceURI());
    }

    @Test
    public void testNodeSetVal() throws XMLException {
        NodeList nodelist = this.context.createExpression("/n:root/n:elem").nodelistEval(this.doc);
        TestCase.assertEquals((int)2, (int)nodelist.getLength());
        TestCase.assertEquals((String)"11", (String)nodelist.item(0).getTextContent().trim());
        TestCase.assertEquals((String)"22", (String)nodelist.item(1).getTextContent().trim());
    }
}

