/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.TestCase;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSResourceResolver;
import org.wamblee.xml.ClasspathUriResolver;
import org.wamblee.xml.XMLDocument;
import org.wamblee.xml.XMLException;
import org.wamblee.xml.XmlUtils;

public class XmlDocumentTest {
    private InputStream getResource(String aResource) {
        return this.getClass().getResourceAsStream(aResource);
    }

    @Test
    public void testReadWriteFromInputStream() throws Exception {
        XMLDocument xmldoc = XMLDocument.xmldocument((String)"test.xml", (InputStream)this.getResource("test.xml"));
        Document doc = xmldoc.getDocument();
        Element element = doc.getDocumentElement();
        TestCase.assertEquals((String)"http://wamblee.org/test", (String)element.getNamespaceURI());
        String val = xmldoc.print(false);
        Document doc2 = XMLDocument.xmldocument((String)"val.xml", (String)val).getDocument();
        XmlUtils.assertEquals("", doc, doc2);
    }

    @Test
    public void testReadWriteFromUri() throws XMLException, URISyntaxException, IOException {
        XMLDocument xmldoc = XMLDocument.xmldocument((URI)this.getClass().getResource("test.xml").toURI());
        Node node = xmldoc.getDocument().getFirstChild();
        TestCase.assertEquals((String)"root", (String)node.getLocalName());
    }

    @Test
    public void testReadWriteFromClassPath() throws XMLException {
        XMLDocument xmldoc = XMLDocument.xmldocument((String)"org/wamblee/xml/test.xml", (LSResourceResolver)new ClasspathUriResolver());
        Node node = xmldoc.getDocument().getFirstChild();
        TestCase.assertEquals((String)"root", (String)node.getLocalName());
    }

    @Test(expected=XMLException.class)
    public void testReadNotWellFormed() throws Exception {
        XMLDocument.xmldocument((String)"testNotWellFormed.xml", (InputStream)this.getResource("testNotWellFormed.xml"));
    }
}

