/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.cache;

public class ComputedValue<T> {
    private Object lock;
    private Computation<T> computedValue;
    private Boolean busy;
    private T value;

    public ComputedValue(Object aLock, Computation aComputation) {
        this.lock = aLock;
        this.computedValue = aComputation;
        this.busy = false;
        this.value = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compute() {
        ComputedValue computedValue = this;
        synchronized (computedValue) {
            if (this.busy.booleanValue()) {
                return;
            }
            this.busy = true;
        }
        try {
            T newvalue = this.computedValue.compute();
            this.set(newvalue);
        }
        finally {
            computedValue = this;
            synchronized (computedValue) {
                this.busy = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        boolean mustCompute = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.computedValue.isOutOfDate()) {
                mustCompute = true;
            }
        }
        if (mustCompute) {
            this.compute();
        }
        object = this.lock;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getCached() {
        Object object = this.lock;
        synchronized (object) {
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(T aValue) {
        Object object = this.lock;
        synchronized (object) {
            this.value = aValue;
        }
    }

    public static interface Computation<T> {
        public boolean isOutOfDate();

        public T compute();
    }
}

