/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.concurrency;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.wamblee.concurrency.ReadLock;
import org.wamblee.concurrency.WriteLock;

public class ReadWriteLockProxyFactory<T> {
    public T getProxy(T aService, Class ... aInterfaces) {
        LockingInvocationHandler<T> handler = new LockingInvocationHandler<T>(aService);
        Class<?> proxyClass = Proxy.getProxyClass(aService.getClass().getClassLoader(), aInterfaces);
        try {
            Object proxy = proxyClass.getConstructor(InvocationHandler.class).newInstance(handler);
            return (T)proxy;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create proxy for " + aService.getClass().getName(), e);
        }
    }

    private static class LockingInvocationHandler<T>
    implements InvocationHandler,
    Serializable {
        private final ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock(true);
        private final ReentrantReadWriteLock.ReadLock rlock = this.rwlock.readLock();
        private final ReentrantReadWriteLock.WriteLock wlock = this.rwlock.writeLock();
        private final ReentrantReadWriteLock cacheRwlock = new ReentrantReadWriteLock(true);
        private final ReentrantReadWriteLock.ReadLock cacheRlock = this.cacheRwlock.readLock();
        private final ReentrantReadWriteLock.WriteLock cacheWlock = this.cacheRwlock.writeLock();
        private T service;
        private Map<Method, LockingType> cache;

        public LockingInvocationHandler(T aService) {
            this.service = aService;
            this.cache = new HashMap<Method, LockingType>();
        }

        @Override
        public Object invoke(Object aProxy, final Method aMethod, final Object[] aArgs) throws Throwable {
            return this.getLockingType(aMethod).handleCase(new LockingSwitch(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object readLock() throws Throwable {
                    LockingInvocationHandler.this.rlock.lock();
                    try {
                        Object object = LockingInvocationHandler.this.doInvoke(aMethod, aArgs);
                        return object;
                    }
                    finally {
                        LockingInvocationHandler.this.rlock.unlock();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object writeLock() throws Throwable {
                    LockingInvocationHandler.this.wlock.lock();
                    try {
                        Object object = LockingInvocationHandler.this.doInvoke(aMethod, aArgs);
                        return object;
                    }
                    finally {
                        LockingInvocationHandler.this.wlock.unlock();
                    }
                }

                @Override
                public Object noLock() throws Throwable {
                    return LockingInvocationHandler.this.doInvoke(aMethod, aArgs);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LockingType getLockingType(Method aMethod) throws NoSuchMethodException {
            this.cacheRlock.lock();
            try {
                LockingType type = this.cache.get(aMethod);
                if (type != null) {
                    LockingType lockingType = type;
                    return lockingType;
                }
            }
            finally {
                this.cacheRlock.unlock();
            }
            this.cacheWlock.lock();
            try {
                Method method = this.service.getClass().getMethod(aMethod.getName(), aMethod.getParameterTypes());
                LockingType type = method.isAnnotationPresent(WriteLock.class) ? LockingType.WRITE : (method.isAnnotationPresent(ReadLock.class) ? LockingType.READ : LockingType.NONE);
                this.cache.put(aMethod, type);
                LockingType lockingType = type;
                return lockingType;
            }
            finally {
                this.cacheWlock.unlock();
            }
        }

        private Object doInvoke(Method aMethod, Object[] aArgs) throws IllegalAccessException, Throwable {
            try {
                return aMethod.invoke(this.service, aArgs);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        private static enum LockingType {
            READ,
            WRITE,
            NONE;


            public Object handleCase(LockingSwitch aSwitch) throws Throwable {
                switch (this) {
                    case READ: {
                        return aSwitch.readLock();
                    }
                    case WRITE: {
                        return aSwitch.writeLock();
                    }
                    case NONE: {
                        return aSwitch.noLock();
                    }
                }
                throw new RuntimeException("Unexpected source location reached");
            }
        }

        private static interface LockingSwitch {
            public Object readLock() throws Throwable;

            public Object writeLock() throws Throwable;

            public Object noLock() throws Throwable;
        }
    }
}

