/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.general;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class LookupProxyFactory<T> {
    private Lookup lookup;
    private Class clazz;

    public LookupProxyFactory(Class<T> aClass, Lookup aLookup) {
        if (!aClass.isInterface()) {
            throw new IllegalArgumentException("Class " + aClass.getName() + " is not an interface");
        }
        this.clazz = aClass;
        this.lookup = aLookup;
    }

    public T getProxy() {
        LookupInvocationHandler handler = new LookupInvocationHandler(this.clazz, this.lookup);
        Class<?> proxyClass = Proxy.getProxyClass(this.clazz.getClassLoader(), this.clazz);
        try {
            Object proxy = proxyClass.getConstructor(InvocationHandler.class).newInstance(handler);
            return (T)proxy;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create proxy for " + this.clazz.getName(), e);
        }
    }

    private static class LookupInvocationHandler<T>
    implements InvocationHandler,
    Serializable {
        private Class clazz;
        private Lookup lookup;

        public LookupInvocationHandler(Class aClass, Lookup aLookup) {
            this.clazz = aClass;
            this.lookup = aLookup;
        }

        @Override
        public Object invoke(Object aProxy, Method aMethod, Object[] aArgs) throws Throwable {
            Object svcObj = null;
            try {
                svcObj = this.lookup.lookup();
            }
            catch (Exception e) {
                throw new LookupException("Error looking up object", e);
            }
            if (svcObj == null) {
                throw new LookupException("Object is null");
            }
            if (!this.clazz.isInstance(svcObj)) {
                throw new LookupException("Object '" + svcObj + "' is not of type " + this.clazz.getName() + " but of type " + svcObj.getClass().getName());
            }
            Object svc = svcObj;
            try {
                return aMethod.invoke(svc, aArgs);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }

    public static class LookupException
    extends RuntimeException {
        public LookupException(String aMsg, Throwable aCause) {
            super(aMsg, aCause);
        }

        public LookupException(String aMsg) {
            super(aMsg);
        }
    }

    public static interface Lookup
    extends Serializable {
        public Object lookup() throws Exception;
    }
}

