/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.general;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.wamblee.general.SerializableInvocationHandler;

public class SerializableProxyFactory<T> {
    private T svc;
    private Class clazz;
    private T proxy;

    public SerializableProxyFactory(Class<T> aClass, T aSvc) {
        if (!aClass.isInterface()) {
            throw new IllegalArgumentException("Class " + aClass.getName() + " is not an interface");
        }
        if (!aClass.isInstance(aSvc)) {
            throw new IllegalArgumentException("Object " + aSvc + " cannot be cast to " + aSvc.getClass());
        }
        this.svc = aSvc;
        this.clazz = aClass;
        this.proxy = this.createProxy();
    }

    public T get() {
        return this.svc;
    }

    public T getProxy() {
        return this.proxy;
    }

    private T createProxy() {
        SerializableInvocationHandler<T> handler = new SerializableInvocationHandler<T>(this.svc, this.clazz);
        Class<?> proxyClass = Proxy.getProxyClass(this.clazz.getClassLoader(), this.clazz);
        try {
            Object proxyObj = proxyClass.getConstructor(InvocationHandler.class).newInstance(handler);
            return (T)proxyObj;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create proxy for " + this.clazz.getName(), e);
        }
    }
}

