/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.general;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.wamblee.general.ThreadSpecificInvocationHandler;

public class ThreadSpecificProxyFactory<T> {
    private ThreadLocal<T> svc;
    private Class clazz;
    private T proxy;

    public ThreadSpecificProxyFactory(Class<T> aClass) {
        this(aClass, null);
    }

    public ThreadSpecificProxyFactory(Class<T> aClass, final CreationCallback<T> aCallback) {
        if (!aClass.isInterface()) {
            throw new IllegalArgumentException("Class " + aClass.getName() + " is not an interface");
        }
        this.svc = new ThreadLocal<T>(){

            @Override
            protected T initialValue() {
                if (aCallback != null) {
                    return aCallback.create();
                }
                return null;
            }
        };
        this.clazz = aClass;
        this.proxy = this.createProxy();
    }

    public void set(T aService) {
        this.svc.set(aService);
    }

    public T get() {
        return this.svc.get();
    }

    public T getProxy() {
        return this.proxy;
    }

    private T createProxy() {
        ThreadSpecificInvocationHandler handler = new ThreadSpecificInvocationHandler(this.svc, this.clazz);
        Class<?> proxyClass = Proxy.getProxyClass(this.clazz.getClassLoader(), this.clazz);
        try {
            Object proxyObj = proxyClass.getConstructor(InvocationHandler.class).newInstance(handler);
            return (T)proxyObj;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create proxy for " + this.clazz.getName(), e);
        }
    }

    public static interface CreationCallback<T> {
        public T create();
    }
}

