/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.observer;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import org.wamblee.observer.Observer;
import org.wamblee.observer.ObserverNotifier;

public class Observable<ObservableType, Event> {
    private ObservableType observable;
    private ObserverNotifier<ObservableType, Event> notifier;
    private Map<Long, Observer<ObservableType, Event>> observers;
    private long counter;

    public Observable(ObservableType aObservable, ObserverNotifier<ObservableType, Event> aNotifier) {
        this.observable = aObservable;
        this.notifier = aNotifier;
        this.observers = new TreeMap<Long, Observer<ObservableType, Event>>();
        this.counter = 0L;
    }

    public synchronized long subscribe(Observer<ObservableType, Event> aObserver) {
        long subscription = this.counter++;
        this.observers.put(subscription, aObserver);
        return subscription;
    }

    public synchronized void unsubscribe(long aSubscription) {
        Observer<ObservableType, Event> obj = this.observers.remove(aSubscription);
        if (obj == null) {
            throw new IllegalArgumentException("Subscription '" + aSubscription + "'");
        }
    }

    public int getObserverCount() {
        return this.observers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Event aEvent) {
        ArrayList<Observer<ObservableType, Event>> myObservers = new ArrayList<Observer<ObservableType, Event>>();
        Observable observable = this;
        synchronized (observable) {
            myObservers.addAll(this.observers.values());
        }
        for (Observer observer : myObservers) {
            this.notifier.update(observer, this.observable, aEvent);
        }
    }
}

