/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.reflection;

import java.lang.reflect.Field;
import org.wamblee.reflection.Accessor;

public class FieldAccessor<T>
implements Accessor<T> {
    private Field field;

    public FieldAccessor(Field aField) {
        this.field = aField;
        this.field.setAccessible(true);
    }

    @Override
    public T get(Object aEntity) {
        try {
            Object value = this.field.get(aEntity);
            return (T)value;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void set(Object aEntity, T aValue) {
        try {
            this.field.set(aEntity, aValue);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public Class<T> getType() {
        return this.field.getType();
    }

    public String toString() {
        return "fieldInjection(" + this.field + ")";
    }
}

