/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.reflection;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wamblee.general.ObjectElem;
import org.wamblee.reflection.ReflectionUtils;

public class ObjectTraversal {
    public static final Logger LOGGER = Logger.getLogger(ObjectTraversal.class.getName());
    private int level = 0;
    private ObjectVisitor visitor;
    private List<ObjectElem> excluded;

    public ObjectTraversal(ObjectVisitor aVisitor) {
        this.visitor = aVisitor;
        this.excluded = new ArrayList<ObjectElem>();
    }

    public void addExcludedObject(Object aObject) {
        this.excluded.add(new ObjectElem(aObject));
    }

    private String indent() {
        StringBuffer buf = new StringBuffer();
        for (int i = 1; i < this.level; ++i) {
            buf.append("    ");
        }
        return buf.toString();
    }

    public void accept(Object aObject) {
        if (aObject == null) {
            return;
        }
        if (aObject.getClass().equals(Object.class)) {
            return;
        }
        if (ReflectionUtils.isPrimitive(aObject.getClass())) {
            return;
        }
        if (!this.visitor.mustVisit(aObject.getClass())) {
            return;
        }
        if (this.alreadyProcessed(aObject)) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            ++this.level;
            LOGGER.finest(this.indent() + "obj: " + aObject);
        }
        if (aObject instanceof List) {
            if (this.visitor.visitList((List)aObject)) {
                this.processList((List)aObject);
            }
            return;
        }
        if (aObject instanceof Map) {
            if (this.visitor.visitMap((Map)aObject)) {
                this.processMap((Map)aObject);
            }
            return;
        }
        if (aObject instanceof Set) {
            if (this.visitor.visitSet((Set)aObject)) {
                this.processSet((Set)aObject);
            }
            return;
        }
        if (aObject.getClass().isArray()) {
            if (this.visitor.visitArray(aObject)) {
                this.processArray(aObject);
            }
            return;
        }
        if (!this.visitor.visitPlainObject(aObject)) {
            return;
        }
        List<Method> methods = ReflectionUtils.getAllMethods(aObject.getClass(), Object.class);
        for (Method getter : methods) {
            if (!getter.getName().startsWith("get") && !getter.getName().startsWith("is") || Modifier.isStatic(getter.getModifiers()) || getter.getParameterTypes().length != 0 || getter.getReturnType() == Void.class || !this.visitor.mustVisit(getter)) continue;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest(this.indent() + "method:  " + getter.getName());
            }
            this.acceptMethod(aObject, getter);
        }
        List<Field> fields = ReflectionUtils.getAllFields(aObject.getClass(), Object.class);
        for (Field field : fields) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
            field.setAccessible(true);
            if (!this.visitor.mustVisit(field)) continue;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest(this.indent() + "field:  " + field.getName());
            }
            this.acceptField(aObject, field);
        }
    }

    private void acceptMethod(Object aObject, Method aGetter) {
        try {
            Object value = aGetter.invoke(aObject, new Object[0]);
            if (value == null) {
                return;
            }
            this.accept(value);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void acceptField(Object aObject, Field aField) {
        try {
            Object value = aField.get(aObject);
            if (value == null) {
                return;
            }
            this.accept(value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void acceptPlainOrCollection(Object aValue) {
        if (aValue instanceof Set) {
            this.visitor.visitSet((Set)aValue);
            this.processSet((Set)aValue);
        } else if (aValue instanceof List) {
            this.processList((List)aValue);
        } else if (aValue instanceof Map) {
            this.processMap((Map)aValue);
        } else if (aValue.getClass().isArray()) {
            this.processArray(aValue);
        } else {
            this.accept(aValue);
        }
    }

    private boolean alreadyProcessed(Object aObject) {
        ObjectElem elem = new ObjectElem(aObject);
        if (this.excluded.contains(elem)) {
            return true;
        }
        this.excluded.add(elem);
        return false;
    }

    private void processList(List aObject) {
        for (Object obj : aObject) {
            this.accept(obj);
        }
    }

    private void processSet(Set aObject) {
        for (Object obj : aObject) {
            this.accept(obj);
        }
    }

    public <Key, Value> void processMap(Map<Key, Value> aMap) {
        Set<Map.Entry<Key, Value>> entries = aMap.entrySet();
        for (Map.Entry<Key, Value> entry : entries) {
            Value value = entry.getValue();
            this.accept(value);
        }
    }

    public void processArray(Object aObject) {
        int size = Array.getLength(aObject);
        for (int i = 0; i < size; ++i) {
            this.accept(Array.get(aObject, i));
        }
    }

    public static interface ObjectVisitor {
        public boolean mustVisit(Class var1);

        public boolean mustVisit(Field var1);

        public boolean mustVisit(Method var1);

        public boolean visitPlainObject(Object var1);

        public boolean visitList(List var1);

        public boolean visitMap(Map var1);

        public boolean visitSet(Set var1);

        public boolean visitArray(Object var1);
    }
}

