/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class SimpleNamespaceContext
implements NamespaceContext {
    private String defaultNs = null;
    private Map<String, String> prefixMap = new HashMap<String, String>();

    public SimpleNamespaceContext() {
    }

    public static SimpleNamespaceContext namespaces() {
        return new SimpleNamespaceContext();
    }

    public SimpleNamespaceContext(String aPrefix, String aNamespace) {
        this();
        this.addPrefix(aPrefix, aNamespace);
    }

    public static SimpleNamespaceContext namespaceContext() {
        return new SimpleNamespaceContext();
    }

    public static SimpleNamespaceContext namespaceContext(String aPrefix, String aNamespace) {
        return new SimpleNamespaceContext(aPrefix, aNamespace);
    }

    public SimpleNamespaceContext defaultNamespace(String aDefaultNs) {
        this.defaultNs = aDefaultNs;
        return this;
    }

    public SimpleNamespaceContext addPrefix(String aPrefix, String aNamespace) {
        if (aPrefix == null) {
            throw new IllegalArgumentException("prefix is null");
        }
        if (aNamespace == null) {
            throw new IllegalArgumentException("namespace is null");
        }
        this.prefixMap.put(aPrefix, aNamespace);
        return this;
    }

    @Override
    public String getNamespaceURI(String aPrefix) {
        if ("".equals(aPrefix)) {
            if (this.defaultNs == null) {
                return "";
            }
            return this.defaultNs;
        }
        if ("xml".equals(aPrefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(aPrefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        String ns = this.prefixMap.get(aPrefix);
        if (ns == null) {
            return "";
        }
        return ns;
    }

    @Override
    public String getPrefix(String aNamespaceURI) {
        List<String> prefixes = this.getPrefixList(aNamespaceURI);
        if (prefixes.isEmpty()) {
            return null;
        }
        return prefixes.get(0);
    }

    public Iterator getPrefixes(String aNamespaceURI) {
        return Collections.unmodifiableList(this.getPrefixList(aNamespaceURI)).iterator();
    }

    public List<String> getPrefixList(String aNamespaceURI) {
        ArrayList<String> result = new ArrayList<String>();
        if (aNamespaceURI == null && this.defaultNs == null || this.defaultNs != null && this.defaultNs.equals(aNamespaceURI)) {
            result.add("");
            return result;
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(aNamespaceURI)) {
            result.add("xml");
            return result;
        }
        if ("http://www.w3.org/2000/xmlns/".equals(aNamespaceURI)) {
            result.add("xmlns");
            return result;
        }
        for (Map.Entry<String, String> entry : this.prefixMap.entrySet()) {
            if (!entry.getValue().equals(aNamespaceURI)) continue;
            result.add(entry.getKey());
        }
        return result;
    }
}

