/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.wamblee.xml.XMLDocument;
import org.wamblee.xml.XMLException;
import org.wamblee.xml.XMLProcessor;
import org.xml.sax.SAXException;

public class XMLSchema
implements XMLProcessor {
    private Schema schema;
    private Validator validator;

    public XMLSchema(URI aUri) throws XMLException {
        try {
            this.initialize(aUri.toString(), aUri.toURL().openStream(), null);
        }
        catch (MalformedURLException e) {
            throw new XMLException("Could not read '" + aUri + "'", e);
        }
        catch (IOException e) {
            throw new XMLException("Could not read '" + aUri + "'", e);
        }
    }

    public XMLSchema(String aSystemId, LSResourceResolver aResolver) throws XMLException {
        LSInput input = aResolver.resolveResource(null, null, null, aSystemId, null);
        if (input == null) {
            throw new XMLException("Schema classpath resource '" + aSystemId + "' not found");
        }
        InputStream is = input.getByteStream();
        this.initialize(aSystemId, is, aResolver);
    }

    private void initialize(String aSystemId, InputStream aIs, LSResourceResolver aResolver) throws XMLException {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            if (aResolver != null) {
                factory.setResourceResolver(aResolver);
            }
            StreamSource source = new StreamSource(aIs);
            source.setSystemId(aSystemId);
            this.schema = factory.newSchema(source);
            this.validator = this.schema.newValidator();
        }
        catch (SAXException e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public static XMLSchema schema(URI aUri) throws XMLException {
        return new XMLSchema(aUri);
    }

    public static XMLSchema schema(String aSystemId, LSResourceResolver aResolver) throws XMLException {
        return new XMLSchema(aSystemId, aResolver);
    }

    private void validateImpl(DOMSource aDoc) throws XMLException {
        try {
            this.validator.validate(aDoc);
        }
        catch (SAXException e) {
            throw new XMLException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public void validate(XMLDocument aDocument) throws XMLException {
        this.validateImpl(aDocument.getDOMSource());
    }

    public void validate(DOMSource aDocument) throws XMLException {
        this.validateImpl(aDocument);
    }

    @Override
    public DOMSource process(DOMSource aDocument) throws XMLException {
        this.validate(aDocument);
        return aDocument;
    }
}

