/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.xml;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wamblee.xml.XMLDocument;
import org.wamblee.xml.XMLException;

public class XPathExpression {
    private String expressionString;
    private javax.xml.xpath.XPathExpression expression;

    public XPathExpression(XPath aXpath, String aExpression) throws XMLException {
        this.expressionString = aExpression;
        try {
            this.expression = aXpath.compile(aExpression);
        }
        catch (XPathExpressionException e) {
            throw new XMLException("Could not compile xpath expression '" + aExpression + "'", e);
        }
    }

    public String stringEval(XMLDocument aDocument) throws XMLException {
        return (String)this.evaluateImpl(aDocument, XPathConstants.STRING);
    }

    public boolean booleanEval(XMLDocument aDocument) throws XMLException {
        return (Boolean)this.evaluateImpl(aDocument, XPathConstants.BOOLEAN);
    }

    public NodeList nodelistEval(XMLDocument aDocument) throws XMLException {
        return (NodeList)this.evaluateImpl(aDocument, XPathConstants.NODESET);
    }

    public Node nodeEval(XMLDocument aDocument) throws XMLException {
        return (Node)this.evaluateImpl(aDocument, XPathConstants.NODE);
    }

    public Double numberEval(XMLDocument aDocument) throws XMLException {
        return (Double)this.evaluateImpl(aDocument, XPathConstants.NUMBER);
    }

    public javax.xml.xpath.XPathExpression getExpression() {
        return this.expression;
    }

    public String getExpressionString() {
        return this.expressionString;
    }

    private Object evaluateImpl(XMLDocument aDocument, QName aResultType) throws XMLException {
        try {
            return this.expression.evaluate(aDocument.getDocument(), aResultType);
        }
        catch (XPathExpressionException e) {
            throw new XMLException("Problem evaluating expression '" + this.expressionString + "' on document '" + aDocument.print(true) + "'", e);
        }
    }
}

