/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.wamblee.xml.XMLException;
import org.wamblee.xml.XMLProcessor;
import org.wamblee.xml.XMLTextProcessor;

public class XSLTransformation
implements XMLProcessor,
XMLTextProcessor {
    private TransformerFactory factory;
    private Transformer transformer;
    private String systemId;

    public XSLTransformation() throws XMLException {
        this.factory = TransformerFactory.newInstance();
        try {
            this.transformer = this.factory.newTransformer();
            this.systemId = "identityTransform";
        }
        catch (TransformerConfigurationException e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public XSLTransformation(URI aUri) throws XMLException {
        try {
            this.factory = TransformerFactory.newInstance();
            StreamSource source = new StreamSource(aUri.toURL().openStream());
            source.setSystemId(aUri.toString());
            this.systemId = aUri.toString();
            this.transformer = this.factory.newTransformer(source);
        }
        catch (MalformedURLException e) {
            throw new XMLException(e.getMessage(), e);
        }
        catch (TransformerConfigurationException e) {
            throw new XMLException(e.getMessage(), e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new XMLException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public XSLTransformation(String aSystemId, URIResolver aResolver) throws XMLException {
        try {
            this.factory = TransformerFactory.newInstance();
            this.factory.setURIResolver(aResolver);
            Source source = aResolver.resolve(aSystemId, null);
            source.setSystemId(aSystemId);
            this.systemId = aSystemId;
            this.transformer = this.factory.newTransformer(source);
        }
        catch (TransformerConfigurationException e) {
            throw new XMLException(e.getMessage(), e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new XMLException(e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    public XSLTransformation setPrettyPrint(boolean aPrettyPrint) {
        this.transformer.setOutputProperty("indent", aPrettyPrint ? "yes" : "no");
        return this;
    }

    public XSLTransformation transformation(URI aUri) throws XMLException {
        return new XSLTransformation(aUri);
    }

    public XSLTransformation transformation(String aSystemId, URIResolver aResolver) throws XMLException {
        return new XSLTransformation(aSystemId, aResolver);
    }

    @Override
    public DOMSource process(DOMSource aDocument) throws XMLException {
        DOMResult result = new DOMResult();
        try {
            this.transform(aDocument, result);
        }
        catch (IOException e) {
            throw new XMLException(e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new XMLException(e.getMessage(), e);
        }
        Document docraw = (Document)result.getNode();
        DOMSource resultSource = new DOMSource(docraw);
        resultSource.setSystemId(aDocument.getSystemId() + "/transformed(" + this.systemId + ")");
        return resultSource;
    }

    @Override
    public void write(DOMSource aDocument, OutputStream aStream) throws XMLException {
        StreamResult result = new StreamResult(aStream);
        try {
            this.transform(aDocument, result);
        }
        catch (IOException e) {
            throw new XMLException(e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new XMLException(e.getMessage(), e);
        }
    }

    private void transform(Source aSource, Result aResult) throws IOException, TransformerException {
        try {
            this.transformer.transform(aSource, aResult);
        }
        catch (TransformerConfigurationException e) {
            throw new TransformerException("Configuration problem of XSLT transformation", e);
        }
    }
}

