/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * This package provides an interface for a cache together with several implementations. 
 * The main interfaces and classes are: 
 * <ul>
 *   <li> {@link Cache}: An interface representing an application-level cache with objects in the 
 *       cache identified by keys. 
 *   </li>
 *   <li> {@link CachedObject}: An object representing an object in a cache identified through a 
 *        key. Upon expiry the cached object invokes a callback to recompute (and cache) the object
 *        again. 
 *   </li>
 *   <li> {@link ComputedValue}: An object caching a computed value with a computation interface 
 *      determining whether the object is out of date and allowing recomputation of the value. 
 *   </li> 
 * </ul>
 */
package org.wamblee.cache;