/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.io;

import java.io.IOException;
import java.io.InputStream;

/**
 * Represents a resource from which information can be read.
 * 
 * @author Erik Brakkee
 */
public interface InputResource {
    /**
     * Gets the input stream to the resource. The obtained input stream must be
     * closed once reading has finished.
     * 
     * @return Input stream to the resource, never null.
     * 
     * @throws IOException
     *             in case the resource cannot be found.
     */
    InputStream getInputStream() throws IOException;
}
