/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.io;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;

/**
 * Filename filter based on regular expressions.
 * 
 * @author Erik Brakkee
 */
public class RegexFilenameFilter implements FileFilter {

    private Pattern pattern;

    /**
     * Constructs the filter.
     * 
     * @param aRegex
     *            Regular expression to filter on.
     */
    public RegexFilenameFilter(String aRegex) {
        pattern = Pattern.compile(aRegex);
    }

    @Override
    public boolean accept(File aPathname) {
        return pattern.matcher(aPathname.getName()).find();
    }

}
