/*
 * Copyright 2005-2010 the original author or authors.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wamblee.reflection;

import java.lang.reflect.Field;

/**
 * Utility for interfacing to a field of an object.
 * 
 * @author Erik Brakkee
 * 
 * @param <T>
 *            Type of the field.
 */
public class FieldAccessor<T> implements Accessor<T> {
    private Field field;

    /**
     * Constructs the accessor.
     * 
     * @param aField
     *            Field.
     */
    public FieldAccessor(Field aField) {
        field = aField;
        field.setAccessible(true);
    }

    @Override
    public T get(Object aEntity) {
        try {
            T value = (T) field.get(aEntity);
            return value;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void set(Object aEntity, T aValue) {
        try {
            field.set(aEntity, aValue);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    /**
     * Gets the field.
     * 
     * @return Field.
     */
    public Field getField() {
        return field;
    }

    @Override
    public Class<T> getType() {
        return (Class<T>) field.getType();
    }

    @Override
    public String toString() {
        return "fieldInjection(" + field + ")";
    }
}