/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.general;

import java.io.Serializable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.wamblee.general.LookupProxyFactory;
import org.wamblee.general.ObjectSerializationUtils;

public class LookupProxyFactoryTest {
    private static final String NAA_NA_NA_NAA_NA = "naa, na, na, naa, na";
    private MyInterface intf;
    private LookupProxyFactory.Lookup lookup;
    private MyInterface proxy;

    @Before
    public void setUp() throws Exception {
        this.intf = (MyInterface)Mockito.mock(MyInterface.class);
        this.lookup = (LookupProxyFactory.Lookup)Mockito.mock(LookupProxyFactory.Lookup.class);
        LookupProxyFactory factory = new LookupProxyFactory(MyInterface.class, this.lookup);
        this.proxy = (MyInterface)factory.getProxy();
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testFound() throws Exception {
        Mockito.when((Object)this.intf.execute()).thenReturn((Object)1);
        Mockito.when((Object)this.lookup.lookup()).thenReturn((Object)this.intf);
        Assert.assertEquals((long)1L, (long)this.proxy.execute());
    }

    @Test(expected=LookupProxyFactory.LookupException.class)
    public void testNotFoundAtJndi() throws Exception {
        Mockito.when((Object)this.lookup.lookup()).thenThrow(new Throwable[]{new RuntimeException("Object not found")});
        this.proxy.execute();
    }

    @Test(expected=LookupProxyFactory.LookupException.class)
    public void testWrongTypeAtJndi() throws Exception {
        Mockito.when((Object)this.lookup.lookup()).thenReturn((Object)"my string");
        Mockito.when((Object)this.intf.execute()).thenReturn((Object)1);
        this.proxy.execute();
    }

    @Test(expected=LookupProxyFactory.LookupException.class)
    public void testNullAtJndi() throws Exception {
        Mockito.when((Object)this.lookup.lookup()).thenReturn(null);
        Mockito.when((Object)this.intf.execute()).thenReturn((Object)1);
        this.proxy.execute();
    }

    @Test
    public void testFoundButInvocationThrowsException() throws Exception {
        Mockito.when((Object)this.intf.execute()).thenThrow(new Throwable[]{new RuntimeException(NAA_NA_NA_NAA_NA)});
        Mockito.when((Object)this.lookup.lookup()).thenReturn((Object)this.intf);
        try {
            this.proxy.execute();
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)NAA_NA_NA_NAA_NA, (Object)e.getMessage());
        }
    }

    @Test
    public void testProxyMustBerializable() throws Exception {
        this.lookup = new MyLookup();
        LookupProxyFactory factory = new LookupProxyFactory(MyInterface.class, this.lookup);
        this.proxy = (MyInterface)factory.getProxy();
        Assert.assertEquals((long)10L, (long)this.proxy.execute());
        Assert.assertTrue((boolean)(this.proxy instanceof Serializable));
        this.proxy = (MyInterface)ObjectSerializationUtils.deserialize((byte[])ObjectSerializationUtils.serialize((Object)this.proxy), MyInterface.class);
        Assert.assertEquals((long)10L, (long)this.proxy.execute());
    }

    private static final class MyLookup
    implements LookupProxyFactory.Lookup {
        private MyLookup() {
        }

        public Object lookup() throws Exception {
            return new MyInterface(){

                @Override
                public int execute() {
                    return 10;
                }
            };
        }
    }

    private static interface MyInterface {
        public int execute();
    }
}

