/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.observer;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.wamblee.observer.DefaultObserverNotifier;
import org.wamblee.observer.Observable;
import org.wamblee.observer.Observer;
import org.wamblee.observer.ObserverNotifier;

public class ObservableTest
extends TestCase {
    private static final int SUBSCRIBER_COUNT = 100;
    private static final String UPDATE = "send";
    private Integer observed;
    private Observable<Integer, String> observable;

    protected void setUp() throws Exception {
        super.setUp();
        this.observed = 1;
        this.observable = new Observable((Object)this.observed, (ObserverNotifier)new DefaultObserverNotifier());
    }

    public void testOneObserver() {
        Observer mockObserver = (Observer)Mockito.mock(Observer.class);
        InOrder order = Mockito.inOrder((Object[])new Object[]{mockObserver});
        long subscription = this.observable.subscribe(mockObserver);
        ObservableTest.assertEquals((int)1, (int)this.observable.getObserverCount());
        String message = "hallo";
        this.observable.send((Object)"hallo");
        ((Observer)order.verify((Object)mockObserver)).send((Object)this.observed, (Object)"hallo");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockObserver});
        this.observable.unsubscribe(subscription);
        ObservableTest.assertEquals((int)0, (int)this.observable.getObserverCount());
        this.observable.send((Object)"hallo");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{mockObserver});
    }

    public void testManySubscribers() {
        int i;
        int i2;
        int nsubscribers = 100;
        Observer[] mocks = new Observer[100];
        InOrder[] order = new InOrder[100];
        ArrayList<Long> subscriptions = new ArrayList<Long>();
        for (int i3 = 0; i3 < 100; ++i3) {
            mocks[i3] = (Observer)Mockito.mock(Observer.class);
            order[i3] = Mockito.inOrder((Object[])new Object[]{mocks[i3]});
            long subscription = this.observable.subscribe(mocks[i3]);
            ObservableTest.assertTrue((boolean)subscriptions.add(subscription));
        }
        ObservableTest.assertEquals((int)100, (int)this.observable.getObserverCount());
        String message = "hallo";
        this.observable.send((Object)"hallo");
        for (i2 = 0; i2 < 100; ++i2) {
            ((Observer)order[i2].verify((Object)mocks[i2])).send((Object)this.observed, (Object)"hallo");
        }
        for (i2 = 50; i2 < 100; ++i2) {
            this.observable.unsubscribe(((Long)subscriptions.get(i2)).longValue());
        }
        ObservableTest.assertEquals((int)50, (int)this.observable.getObserverCount());
        String message2 = "blabla";
        this.observable.send((Object)"blabla");
        for (i = 0; i < 50; ++i) {
            ((Observer)order[i].verify((Object)mocks[i])).send((Object)this.observed, (Object)"blabla");
        }
        for (i = 50; i < 100; ++i) {
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{mocks[i]});
        }
    }

    public void testUnsubscribeWithWrongSubscription() {
        Observer observer = (Observer)Mockito.mock(Observer.class);
        long subscription = this.observable.subscribe(observer);
        ObservableTest.assertEquals((int)1, (int)this.observable.getObserverCount());
        try {
            this.observable.unsubscribe(subscription + 1L);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        ObservableTest.fail();
    }
}

