/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.persistence;

import junit.framework.TestCase;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.wamblee.persistence.AbstractDetachable;

public class AbstractDetachableTest {
    private DetachableMethods methods;
    private AbstractDetachable<X, Integer> detachable;
    private X x;

    @Before
    public void setUp() {
        this.methods = (DetachableMethods)Mockito.mock(DetachableMethods.class);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullPassedIn() {
        this.detachable = new MyDetachable(null);
    }

    @Test
    public void testDetach() {
        this.x = new X();
        Integer ref = 100;
        Mockito.when((Object)this.methods.getReference((X)Mockito.any(X.class))).thenReturn((Object)ref);
        this.detachable = new MyDetachable(this.x);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.methods});
        this.detachable.detach();
        ((DetachableMethods)Mockito.verify((Object)this.methods)).getReference((X)Mockito.same((Object)this.x));
        TestCase.assertNull((Object)this.detachable.getObject());
        TestCase.assertEquals((Object)ref, (Object)this.detachable.getReference());
    }

    @Test
    public void testDetachTwice() {
        Mockito.reset((Object[])new DetachableMethods[]{this.methods});
        this.testDetach();
        this.detachable.detach();
        this.detachable.detach();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.methods});
    }

    @Test(expected=IllegalStateException.class)
    public void testDetachWithNullReference() {
        this.x = new X();
        Integer ref = 100;
        Mockito.when((Object)this.methods.getReference((X)Mockito.any(X.class))).thenReturn(null);
        this.detachable = new MyDetachable(this.x);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.methods});
        this.detachable.detach();
    }

    @Test
    public void testReattach() {
        this.testDetach();
        Mockito.reset((Object[])new DetachableMethods[]{this.methods});
        X x2 = new X();
        Mockito.when((Object)this.methods.load((Integer)this.detachable.getReference())).thenReturn((Object)x2);
        X x3 = (X)this.detachable.get();
        ((DetachableMethods)Mockito.verify((Object)this.methods)).load(100);
        TestCase.assertSame((Object)x2, (Object)x3);
        TestCase.assertSame((Object)x2, (Object)this.detachable.getObject());
    }

    @Test
    public void testGetInvokedTwiceNoLoads() {
        this.testReattach();
        Mockito.reset((Object[])new DetachableMethods[]{this.methods});
        this.detachable.get();
        this.detachable.get();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.methods});
    }

    public class MyDetachable
    extends AbstractDetachable<X, Integer> {
        public MyDetachable(X aObj) {
            super((Object)aObj);
        }

        protected Integer getReference(X aObject) {
            return AbstractDetachableTest.this.methods.getReference(aObject);
        }

        protected X load(Integer aReference) {
            return AbstractDetachableTest.this.methods.load(aReference);
        }
    }

    public static interface DetachableMethods {
        public Integer getReference(X var1);

        public X load(Integer var1);
    }

    public static class X {
    }
}

