/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Id;
import javax.persistence.Version;
import junit.framework.Assert;
import org.junit.Test;
import org.wamblee.persistence.JpaMergeSupport;

public class JpaMergeSupportTest {
    @Test
    public void testSimple() {
        X1 x = new X1();
        x.id = 10;
        x.version = 20;
        X1 y = new X1();
        JpaMergeSupport.merge((Object)x, (Object)y);
        Assert.assertEquals((int)x.id, (int)y.id);
        Assert.assertEquals((int)x.version, (int)y.version);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSimplePkMismatch() {
        X1 x = new X1();
        x.id = 10;
        x.version = 20;
        X1 y = new X1();
        y.id = 5;
        JpaMergeSupport.merge((Object)x, (Object)y);
    }

    @Test
    public void testTraverseList() {
        X2 x = new X2();
        x.id = 10;
        X1 a = new X1();
        a.id = 20;
        a.version = 21;
        X1 b = new X1();
        b.id = 30;
        b.version = 31;
        x.getList().add(a);
        x.getList().add(b);
        X2 y = new X2();
        y.getList().add(new X1());
        y.getList().add(new X1());
        JpaMergeSupport.merge((Object)x, (Object)y);
        Assert.assertEquals((int)x.id, (int)y.id);
        Assert.assertEquals((int)x.getList().get(0).id, (int)y.getList().get(0).id);
        Assert.assertEquals((int)x.getList().get(1).id, (int)y.getList().get(1).id);
        Assert.assertEquals((int)x.getList().get(0).version, (int)y.getList().get(0).version);
        Assert.assertEquals((int)x.getList().get(1).version, (int)y.getList().get(1).version);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTraverseListWrongSize() {
        X2 x = new X2();
        x.id = 10;
        X1 a = new X1();
        a.id = 20;
        a.version = 21;
        X1 b = new X1();
        b.id = 30;
        b.version = 31;
        x.getList().add(a);
        x.getList().add(b);
        X2 y = new X2();
        y.getList().add(new X1());
        JpaMergeSupport.merge((Object)x, (Object)y);
    }

    @Test
    public void testTraverseSet() {
        X3 x = new X3();
        x.id = 10;
        X1 a = new X1("a");
        a.id = 20;
        a.version = 21;
        X1 b = new X1("b");
        b.id = 30;
        b.version = 21;
        x.getSet().add(a);
        x.getSet().add(b);
        X3 y = new X3();
        X1 ya = new X1("a");
        X1 yb = new X1("b");
        y.getSet().add(ya);
        y.getSet().add(yb);
        JpaMergeSupport.merge((Object)x, (Object)y);
        Assert.assertEquals((int)x.id, (int)y.id);
        Assert.assertEquals((int)a.id, (int)ya.id);
        Assert.assertEquals((int)a.version, (int)ya.version);
        Assert.assertEquals((int)b.version, (int)yb.version);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTraverseSetWrongSize() {
        X3 x = new X3();
        x.id = 10;
        X1 a = new X1("a");
        a.id = 20;
        a.version = 21;
        X1 b = new X1("b");
        b.id = 30;
        b.version = 21;
        x.getSet().add(a);
        x.getSet().add(b);
        X3 y = new X3();
        X1 ya = new X1("a");
        X1 yb = new X1("b");
        y.getSet().add(ya);
        JpaMergeSupport.merge((Object)x, (Object)y);
    }

    @Test
    public void testTraverseMap() {
        X4 x = new X4();
        x.id = 10;
        X1 a = new X1("a");
        a.id = 20;
        a.version = 21;
        X1 b = new X1("b");
        b.id = 30;
        b.version = 21;
        x.getMap().put("a", a);
        x.getMap().put("b", b);
        X4 y = new X4();
        X1 ya = new X1("a");
        X1 yb = new X1("b");
        y.getMap().put("a", ya);
        y.getMap().put("b", yb);
        JpaMergeSupport.merge((Object)x, (Object)y);
        Assert.assertEquals((int)x.id, (int)y.id);
        Assert.assertEquals((int)a.id, (int)ya.id);
        Assert.assertEquals((int)a.version, (int)ya.version);
        Assert.assertEquals((int)b.version, (int)yb.version);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTraverseMapWrongKey() {
        X4 x = new X4();
        x.id = 10;
        X1 a = new X1("a");
        a.id = 20;
        a.version = 21;
        X1 b = new X1("b");
        b.id = 30;
        b.version = 21;
        x.getMap().put("a", a);
        x.getMap().put("b", b);
        X4 y = new X4();
        X1 ya = new X1("a");
        X1 yb = new X1("b");
        y.getMap().put("a", ya);
        y.getMap().put("c", yb);
        JpaMergeSupport.merge((Object)x, (Object)y);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTraverseMapWrongSize() {
        X4 x = new X4();
        x.id = 10;
        X1 a = new X1("a");
        a.id = 20;
        a.version = 21;
        X1 b = new X1("b");
        b.id = 30;
        b.version = 21;
        x.getMap().put("a", a);
        x.getMap().put("b", b);
        X4 y = new X4();
        X1 ya = new X1("a");
        X1 yb = new X1("b");
        y.getMap().put("a", ya);
        JpaMergeSupport.merge((Object)x, (Object)y);
    }

    @Test
    public void testTraverseArray() {
        X5 x = new X5();
        x.id = 10;
        X1 a = new X1("a");
        a.id = 20;
        a.version = 21;
        X1 b = new X1("b");
        b.id = 30;
        b.version = 21;
        x.setArray(new X1[]{a, b});
        X5 y = new X5();
        X1 ya = new X1("a");
        X1 yb = new X1("b");
        y.setArray(new X1[]{ya, yb});
        JpaMergeSupport.merge((Object)x, (Object)y);
        Assert.assertEquals((int)x.id, (int)y.id);
        Assert.assertEquals((int)a.id, (int)ya.id);
        Assert.assertEquals((int)a.version, (int)ya.version);
        Assert.assertEquals((int)b.version, (int)yb.version);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTraverseArrayWrongSize() {
        X5 x = new X5();
        x.id = 10;
        X1 a = new X1("a");
        a.id = 20;
        a.version = 21;
        X1 b = new X1("b");
        b.id = 30;
        b.version = 21;
        x.setArray(new X1[]{a, b});
        X5 y = new X5();
        X1 ya = new X1("a");
        y.setArray(new X1[]{ya});
        JpaMergeSupport.merge((Object)x, (Object)y);
    }

    @Test
    public void testNotAGetter() {
        X6 x = new X6();
        x.id = 100;
        X6 y = new X6();
        JpaMergeSupport.merge((Object)x, (Object)y);
        Assert.assertEquals((int)x.id, (int)y.id);
    }

    @Test
    public void testPrivateGetter() {
        X7 x = new X7();
        x.id = 100;
        X7 y = new X7();
        JpaMergeSupport.merge((Object)x, (Object)y);
        Assert.assertEquals((int)x.id, (int)y.id);
    }

    private static class X7 {
        @Id
        private int id;

        private X7() {
        }

        private void getX() {
            Assert.fail((String)"Private getters should not be used");
        }
    }

    private static class X6 {
        @Id
        private int id;

        private X6() {
        }

        public X1 getNotaGetter(String aMessage) {
            return null;
        }

        public void getNotaGetter2() {
        }
    }

    private static class X5 {
        @Id
        private int id;
        private X1[] array;

        public void setArray(X1[] aArray) {
            this.array = aArray;
        }

        public X1[] getArray() {
            return this.array;
        }
    }

    private static class X4 {
        @Id
        private int id;
        private Map<String, X1> map = new HashMap<String, X1>();

        public Map<String, X1> getMap() {
            return this.map;
        }
    }

    private static class X3 {
        @Id
        private int id;
        private Set<X1> set = new HashSet<X1>();

        public Set<X1> getSet() {
            return this.set;
        }
    }

    private static class X2 {
        @Id
        private int id;
        private List<X1> list = new ArrayList<X1>();

        public List<X1> getList() {
            return this.list;
        }
    }

    private static class X1 {
        @Id
        private int id;
        @Version
        private int version;
        private String value;

        public X1() {
            this.value = "";
        }

        public X1(String aValue) {
            this.value = aValue;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object aObj) {
            if (aObj == null) {
                return false;
            }
            if (!(aObj instanceof X1)) {
                return false;
            }
            return this.value.equals(((X1)aObj).getValue());
        }

        public int hashCode() {
            return 0;
        }
    }
}

