/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.persistence;

import java.io.Serializable;
import javax.persistence.Id;
import javax.persistence.Version;
import junit.framework.Assert;
import org.junit.Test;
import org.wamblee.persistence.PersistentFactory;
import org.wamblee.reflection.FieldAccessor;
import org.wamblee.reflection.PropertyAccessor;

public class PersistentFactoryTest {
    @Test
    public void testFieldAccessorSet() throws Exception {
        FieldAccessor accessor = new FieldAccessor(X1.class.getDeclaredField("pk"));
        X1 x1 = new X1();
        Assert.assertEquals((int)0, (int)x1.getPk());
        accessor.set((Object)x1, (Object)10);
        Assert.assertEquals((int)10, (int)x1.getPk());
    }

    @Test
    public void testPropertyAccessorSet() throws Exception {
        PropertyAccessor accessor = new PropertyAccessor(X1.class.getDeclaredMethod("getPk", new Class[0]), X1.class.getDeclaredMethod("setPk", Integer.TYPE));
        X1 x1 = new X1();
        Assert.assertEquals((int)0, (int)x1.getPk());
        accessor.set((Object)x1, (Object)10);
        Assert.assertEquals((int)10, (int)x1.getPk());
    }

    @Test
    public void testPropertyAccessorPrivate() throws Exception {
        PropertyAccessor accessor = new PropertyAccessor(X1.class.getDeclaredMethod("privateGetter", new Class[0]), X1.class.getDeclaredMethod("privateSetter", Integer.TYPE));
        X1 x1 = new X1();
        Assert.assertEquals((int)0, (int)x1.getPk());
        accessor.set((Object)x1, (Object)10);
        Assert.assertEquals((Object)10, (Object)accessor.get((Object)x1));
    }

    @Test
    public void testEntityAccessorPkField() {
        PersistentFactory.EntityAccessor accessor = PersistentFactory.createEntityAccessor(X1.class);
        Assert.assertNotNull((Object)accessor);
        Assert.assertTrue((boolean)(accessor.getPk() instanceof FieldAccessor));
        Assert.assertNull((Object)accessor.getVersion());
        Assert.assertEquals((String)"pk", (String)((FieldAccessor)accessor.getPk()).getField().getName());
    }

    @Test
    public void testEntityAccessorPkProperty() {
        PersistentFactory.EntityAccessor accessor = PersistentFactory.createEntityAccessor(X2.class);
        Assert.assertNotNull((Object)accessor);
        Assert.assertNotNull((Object)accessor.getPk());
        Assert.assertTrue((boolean)(accessor.getPk() instanceof PropertyAccessor));
        Assert.assertNull((Object)accessor.getVersion());
        PropertyAccessor property = (PropertyAccessor)accessor.getPk();
        Assert.assertEquals((String)"getPk", (String)property.getGetter().getName());
        Assert.assertEquals((String)"setPk", (String)property.getSetter().getName());
    }

    @Test
    public void testEntityAccessorPkPropertyPrivate() {
        PersistentFactory.EntityAccessor accessor = PersistentFactory.createEntityAccessor(X3.class);
        Assert.assertNotNull((Object)accessor);
        Assert.assertNotNull((Object)accessor.getPk());
        Assert.assertTrue((boolean)(accessor.getPk() instanceof PropertyAccessor));
        Assert.assertNull((Object)accessor.getVersion());
        PropertyAccessor property = (PropertyAccessor)accessor.getPk();
        Assert.assertEquals((String)"getPk", (String)property.getGetter().getName());
        Assert.assertEquals((String)"setPk", (String)property.getSetter().getName());
    }

    @Test
    public void testEntityAccessorVersionField() {
        PersistentFactory.EntityAccessor accessor = PersistentFactory.createEntityAccessor(X4.class);
        Assert.assertNotNull((Object)accessor);
        Assert.assertTrue((boolean)(accessor.getVersion() instanceof FieldAccessor));
        Assert.assertNull((Object)accessor.getPk());
        Assert.assertEquals((String)"version", (String)((FieldAccessor)accessor.getVersion()).getField().getName());
    }

    @Test
    public void testEntityAccessorVersionProperty() {
        PersistentFactory.EntityAccessor accessor = PersistentFactory.createEntityAccessor(X5.class);
        Assert.assertNotNull((Object)accessor);
        Assert.assertNotNull((Object)accessor.getVersion());
        Assert.assertTrue((boolean)(accessor.getVersion() instanceof PropertyAccessor));
        Assert.assertNull((Object)accessor.getPk());
        PropertyAccessor property = (PropertyAccessor)accessor.getVersion();
        Assert.assertEquals((String)"getVersion", (String)property.getGetter().getName());
        Assert.assertEquals((String)"setVersion", (String)property.getSetter().getName());
    }

    @Test
    public void testEntityAccessorVersionPropertyPrivate() {
        PersistentFactory.EntityAccessor accessor = PersistentFactory.createEntityAccessor(X6.class);
        Assert.assertNotNull((Object)accessor);
        Assert.assertNotNull((Object)accessor.getVersion());
        Assert.assertTrue((boolean)(accessor.getVersion() instanceof PropertyAccessor));
        Assert.assertNull((Object)accessor.getPk());
        PropertyAccessor property = (PropertyAccessor)accessor.getVersion();
        Assert.assertEquals((String)"getVersion", (String)property.getGetter().getName());
        Assert.assertEquals((String)"setVersion", (String)property.getSetter().getName());
    }

    @Test
    public void testNoVersionAndNoPk() {
        PersistentFactory.EntityAccessor accessor = PersistentFactory.createEntityAccessor(String.class);
        Assert.assertNull((Object)accessor);
    }

    @Test
    public void testPkAndVersion() {
        PersistentFactory.EntityAccessor accessor = PersistentFactory.createEntityAccessor(X7.class);
        Assert.assertNotNull((Object)accessor.getPk());
        Assert.assertNotNull((Object)accessor.getVersion());
        X7 x = new X7();
        Assert.assertEquals((int)0, (int)x.id);
        Assert.assertEquals((int)0, (int)x.version);
        accessor.getPk().set((Object)x, (Object)10);
        accessor.getVersion().set((Object)x, (Object)20);
        Assert.assertEquals((int)10, (int)x.id);
        Assert.assertEquals((int)20, (int)x.version);
    }

    @Test
    public void testEntityAccessorCache() {
        PersistentFactory.EntityAccessor accessor = PersistentFactory.createEntityAccessor(X1.class);
        PersistentFactory.EntityAccessor accessor2 = PersistentFactory.createEntityAccessor(X1.class);
        Assert.assertSame((Object)accessor, (Object)accessor2);
    }

    @Test
    public void testEntityObjectAccessorRobustness() {
        PersistentFactory.EntityObjectAccessor accessor = new PersistentFactory.EntityObjectAccessor((Object)"hello world", new PersistentFactory.EntityAccessor(null, null));
        Assert.assertNull((Object)accessor.getPrimaryKey());
        Assert.assertNull((Object)accessor.getPersistedVersion());
        accessor.setPrimaryKey((Serializable)((Object)"bla"));
        accessor.setPersistedVersion((Number)100);
    }

    public static class X7 {
        @Id
        public int id;
        @Version
        public int version;
    }

    public static class X6 {
        private int version;

        @Version
        private int getVersion() {
            return this.version;
        }

        private void setVersion(int aVersion) {
            this.version = aVersion;
        }
    }

    public static class X5 {
        private int version;

        @Version
        public int getVersion() {
            return this.version;
        }

        public void setVersion(int aVersion) {
            this.version = aVersion;
        }
    }

    public static class X4 {
        @Version
        private int version;

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int aVersion) {
            this.version = aVersion;
        }

        private void privateSetter(int aVersion) {
            this.version = aVersion;
        }

        private int privateGetter() {
            return this.version;
        }
    }

    public static class X3 {
        private int pk;

        @Id
        private int getPk() {
            return this.pk;
        }

        private void setPk(int aPk) {
            this.pk = aPk;
        }
    }

    public static class X2 {
        private int pk;

        @Id
        public int getPk() {
            return this.pk;
        }

        public void setPk(int aPk) {
            this.pk = aPk;
        }
    }

    public static class X1 {
        @Id
        private int pk;

        public int getPk() {
            return this.pk;
        }

        public void setPk(int aPk) {
            this.pk = aPk;
        }

        private void privateSetter(int aPk) {
            this.pk = aPk;
        }

        private int privateGetter() {
            return this.pk;
        }
    }
}

