/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.wamblee.reflection.ObjectTraversal;

public class ObjectTraversalTest {
    @Mock
    private ObjectTraversal.ObjectVisitor visitor;
    private ObjectTraversal traversal;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.traversal = new ObjectTraversal(this.visitor);
        Mockito.when((Object)this.visitor.mustVisit((Class)Mockito.any(Class.class))).thenReturn((Object)true);
        Mockito.when((Object)this.visitor.mustVisit((Field)Mockito.any(Field.class))).thenReturn((Object)true);
        Mockito.when((Object)this.visitor.mustVisit((Method)Mockito.any(Method.class))).thenReturn((Object)true);
        Mockito.when((Object)this.visitor.visitPlainObject(Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)this.visitor.visitArray(Mockito.any())).thenReturn((Object)true);
        Mockito.when((Object)this.visitor.visitList((List)Mockito.any(List.class))).thenReturn((Object)true);
        Mockito.when((Object)this.visitor.visitMap((Map)Mockito.any(Map.class))).thenReturn((Object)true);
        Mockito.when((Object)this.visitor.visitSet((Set)Mockito.any(Set.class))).thenReturn((Object)true);
        ObjectTraversal.LOGGER.setLevel(Level.FINEST);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.FINEST);
        ObjectTraversal.LOGGER.addHandler(handler);
    }

    @Test
    public void testTraverseFields() throws Exception {
        X2 x2 = new X2();
        X1 x1 = new X1();
        x2.x = x1;
        this.traversal.accept((Object)x2);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).mustVisit(X2.class);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).mustVisit(X1.class);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).mustVisit((Field)Mockito.eq((Object)X2.class.getDeclaredField("x")));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitPlainObject(Mockito.same((Object)x2));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitPlainObject(Mockito.same((Object)x1));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.visitor});
    }

    @Test
    public void testNonTraversedFields() throws Exception {
        TraversalNonTraversedFields obj = new TraversalNonTraversedFields();
        this.traversal.accept((Object)obj);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).mustVisit(TraversalNonTraversedFields.class);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).mustVisit((Field)Mockito.eq((Object)TraversalNonTraversedFields.class.getDeclaredField("x")));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).mustVisit((Field)Mockito.eq((Object)TraversalNonTraversedFields.class.getDeclaredField("y")));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitPlainObject(Mockito.same((Object)obj));
    }

    @Test
    public void testTraverseMethods() throws Exception {
        X4 x4 = new X4();
        this.traversal.accept((Object)x4);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).mustVisit(X4.class);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).mustVisit(X3.class);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).mustVisit((Method)Mockito.eq((Object)X4.class.getDeclaredMethod("getX3", new Class[0])));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitPlainObject(Mockito.same((Object)x4));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitPlainObject(Mockito.isA(X3.class));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.visitor});
    }

    @Test
    public void testTraverseList() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new X1());
        list.add(new X3());
        this.traversal.accept(list);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitList((List)Mockito.same(list));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitPlainObject(Mockito.isA(X1.class));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitPlainObject(Mockito.isA(X3.class));
    }

    @Test
    public void testTraverseMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x1", new X1());
        map.put("x3", new X3());
        this.traversal.accept(map);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitMap((Map)Mockito.same(map));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitPlainObject(Mockito.isA(X1.class));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitPlainObject(Mockito.isA(X3.class));
    }

    @Test
    public void testTraverseSet() {
        HashSet<Object> set = new HashSet<Object>();
        set.add(new X1());
        set.add(new X3());
        this.traversal.accept(set);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitSet((Set)Mockito.same(set));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitPlainObject(Mockito.isA(X1.class));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitPlainObject(Mockito.isA(X3.class));
    }

    @Test
    public void testTraverseArray() {
        Object[] obj = new Object[]{new X1(), new X3()};
        this.traversal.accept((Object)obj);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitArray(Mockito.same((Object)obj));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitPlainObject(Mockito.isA(X1.class));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitPlainObject(Mockito.isA(X3.class));
    }

    @Test
    public void testExcludeClasses() {
        X2 x2 = new X2();
        x2.x = new X1();
        Mockito.when((Object)this.visitor.mustVisit(X1.class)).thenReturn((Object)false);
        this.traversal.accept((Object)x2);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitPlainObject(Mockito.same((Object)x2));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor, (VerificationMode)Mockito.never())).visitPlainObject(Mockito.same((Object)x2.x));
    }

    @Test
    public void testExcludeFields() {
        X2 x2 = new X2();
        x2.x = new X1();
        Mockito.when((Object)this.visitor.mustVisit((Field)Mockito.any(Field.class))).thenReturn((Object)false);
        this.traversal.accept((Object)x2);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitPlainObject(Mockito.same((Object)x2));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor, (VerificationMode)Mockito.never())).visitPlainObject(Mockito.same((Object)x2.x));
    }

    @Test
    public void testExcludeMethods() {
        X4 x4 = new X4();
        Mockito.when((Object)this.visitor.mustVisit((Method)Mockito.any(Method.class))).thenReturn((Object)false);
        this.traversal.accept((Object)x4);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitPlainObject(Mockito.same((Object)x4));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor, (VerificationMode)Mockito.never())).visitPlainObject(Mockito.isA(X3.class));
    }

    @Test
    public void testCyclic() {
        X6 x6 = new X6();
        X5 x5 = new X5();
        x6.x5 = x5;
        x5.x6 = x6;
        this.traversal.accept((Object)x6);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitPlainObject(Mockito.same((Object)x6));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitPlainObject(Mockito.same((Object)x5));
    }

    @Test
    public void testCyclicList() {
        ArrayList list = new ArrayList();
        list.add(list);
        this.traversal.accept(list);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor, (VerificationMode)Mockito.times((int)1))).visitList((List)Mockito.same(list));
    }

    @Test
    public void testCyclicMap() {
        HashMap map = new HashMap();
        map.put("x", map);
        this.traversal.accept(map);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor, (VerificationMode)Mockito.times((int)1))).visitMap((Map)Mockito.same(map));
    }

    @Test
    public void testCyclicSet() {
        HashSet set = new HashSet();
        set.add(set);
        this.traversal.accept(set);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor, (VerificationMode)Mockito.times((int)1))).visitSet((Set)Mockito.same(set));
    }

    @Test
    public void testCyclicArray() {
        Object[] obj;
        obj[0] = obj = new Object[1];
        this.traversal.accept((Object)obj);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor, (VerificationMode)Mockito.times((int)1))).visitArray(Mockito.same((Object)obj));
    }

    @Test
    public void testVisitNull() {
        this.traversal.accept(null);
    }

    @Test
    public void testExcludeFieldByReturningFalseInVisit() {
        X2 x2 = new X2();
        x2.x = new X1();
        Mockito.when((Object)this.visitor.visitPlainObject(Mockito.any())).thenReturn((Object)false);
        this.traversal.accept((Object)x2);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitPlainObject(Mockito.same((Object)x2));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor, (VerificationMode)Mockito.never())).visitPlainObject(Mockito.same((Object)x2.x));
    }

    @Test
    public void testTraverseListExcludeElements() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new X1());
        list.add(new X3());
        Mockito.when((Object)this.visitor.visitList((List)Mockito.any(List.class))).thenReturn((Object)false);
        this.traversal.accept(list);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitList((List)Mockito.same(list));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor, (VerificationMode)Mockito.never())).visitPlainObject(Mockito.any());
    }

    @Test
    public void testTraverseMapExcludeElements() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x1", new X1());
        map.put("x3", new X3());
        Mockito.when((Object)this.visitor.visitMap((Map)Mockito.any(Map.class))).thenReturn((Object)false);
        this.traversal.accept(map);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitMap((Map)Mockito.same(map));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor, (VerificationMode)Mockito.never())).visitPlainObject(Mockito.any());
    }

    @Test
    public void testTraverseSetExcludeElements() {
        HashSet<Object> set = new HashSet<Object>();
        set.add(new X1());
        set.add(new X3());
        Mockito.when((Object)this.visitor.visitSet((Set)Mockito.any(Set.class))).thenReturn((Object)false);
        this.traversal.accept(set);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitSet((Set)Mockito.same(set));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor, (VerificationMode)Mockito.never())).visitPlainObject(Mockito.any());
    }

    @Test
    public void testTraverseArrayExcludeElements() {
        Object[] obj = new Object[]{new X1(), new X3()};
        Mockito.when((Object)this.visitor.visitArray(Mockito.any())).thenReturn((Object)false);
        this.traversal.accept((Object)obj);
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor)).visitArray(Mockito.same((Object)obj));
        ((ObjectTraversal.ObjectVisitor)Mockito.verify((Object)this.visitor, (VerificationMode)Mockito.never())).visitPlainObject(Mockito.any());
    }

    public static class X6 {
        private X5 x5;
    }

    public static class X5 {
        private X6 x6;
    }

    public static class X4 {
        public X3 getX3() {
            return new X3();
        }
    }

    public static class X3 {
    }

    public static class TraversalNonTraversedFields {
        private int x;
        private Object y = new Object();
    }

    public static class X2 {
        private X1 x;
    }

    public static class X1 {
    }
}

