/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.wamblee.reflection.ReflectionUtils;

public class ReflectionUtilsTest {
    @Test(expected=IllegalArgumentException.class)
    public void testGetAllMethodsInterface() {
        ReflectionUtils.getAllMethods(X.class, (Class[])new Class[0]);
    }

    @Test
    public void testBasicClass() {
        List res = ReflectionUtils.getAllMethods(X2.class, (Class[])new Class[]{Object.class});
        Assert.assertEquals((int)2, (int)res.size());
    }

    @Test
    public void testInheritanceAdditionalMethod() {
        List res = ReflectionUtils.getAllMethods(X3.class, (Class[])new Class[]{Object.class});
        Assert.assertEquals((int)3, (int)res.size());
    }

    @Test
    public void testInheritanceOverriddenMethod() {
        List res = ReflectionUtils.getAllMethods(X4.class, (Class[])new Class[]{Object.class});
        Assert.assertEquals((int)2, (int)res.size());
        for (Method method : res) {
            if (!method.getName().equals("x")) continue;
            Assert.assertEquals(X4.class, method.getDeclaringClass());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetAllFieldsInterface() {
        ReflectionUtils.getAllFields(X.class, (Class[])new Class[0]);
    }

    @Test
    public void testFieldsFromBasicClass() {
        List fields = ReflectionUtils.getAllFields(X2.class, (Class[])new Class[0]);
        Assert.assertEquals((int)1, (int)fields.size());
        Assert.assertEquals((String)"bla", (String)((Field)fields.get(0)).getName());
    }

    public void testFieldsWithInheritance() {
        List fields = ReflectionUtils.getAllFields(X5.class, (Class[])new Class[0]);
        Assert.assertEquals((int)3, (int)fields.size());
    }

    public static class X5
    extends X2 {
        private String field;
        private int g;
    }

    public static class X4
    extends X2 {
        @Override
        public void x() {
        }
    }

    public static class X3
    extends X2 {
        public void z() {
        }
    }

    public static class X2 {
        private int bla;

        public void x() {
        }

        private void y() {
        }
    }

    public static interface X {
        public void x();
    }
}

