/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.xml;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import javax.xml.transform.URIResolver;
import junit.framework.TestCase;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.ls.LSResourceResolver;
import org.wamblee.io.ClassPathResource;
import org.wamblee.xml.ClasspathUriResolver;
import org.wamblee.xml.XMLDocument;
import org.wamblee.xml.XMLException;
import org.wamblee.xml.XMLTextProcessor;
import org.wamblee.xml.XSLTransformation;
import org.wamblee.xml.XmlUtils;

public class XSLTransformationTest {
    private static final String PREFIX = "org/wamblee/xml/";
    private static final String INCLUDED_XSL_FILE = "utilities.xsl";
    private static final String REPORT_XML = "report.xml";
    private static final String REPORT_TO_HTML_XSLT = "reportToHtml.xsl";
    private static final String REPORT_TO_HTML2_XSLT = "reportToHtml2.xsl";
    private static final String REPORT_TO_HTML_INVALID_XSLT = "reportToHtml-invalid.xsl";
    private static final String REPORT_TO_HTML_NONWELLFORMED_XSLT = "reportToHtml-nonwellformed.xsl";
    private static final String REPORT_TO_TEXT_XSLT = "reportToText.xsl";

    private String getResourcePath(String aResource) {
        return this.getClass().getPackage().getName().replaceAll("\\.", "/") + "/" + aResource;
    }

    @Test
    public void testTransformUsingDefaultResolver() throws Exception {
        XMLDocument xmldoc = XMLDocument.xmldocument((String)"org/wamblee/xml/report.xml", (LSResourceResolver)new ClasspathUriResolver());
        XMLDocument transformed = xmldoc.transform(this.getClass().getResource(REPORT_TO_HTML_XSLT).toURI());
        Document expected = XMLDocument.xmldocument((URI)this.getClass().getResource("output-reportToHtml-report.xml").toURI()).getDocument();
        Document output = transformed.getDocument();
        XmlUtils.assertEquals("byte[] transform", expected, output);
    }

    @Test
    public void testTransformUsingDefaultResolverTextTransform() throws Exception {
        XMLDocument xmldoc = XMLDocument.xmldocument((String)"org/wamblee/xml/report.xml", (LSResourceResolver)new ClasspathUriResolver());
        String transformed = xmldoc.write((XMLTextProcessor)new XSLTransformation(this.getClass().getResource(REPORT_TO_HTML_XSLT).toURI()));
        XMLDocument xmldocTransformed = XMLDocument.xmldocument((String)"read-transformed-text", (InputStream)new ByteArrayInputStream(transformed.getBytes()));
        Document expected = XMLDocument.xmldocument((String)"output-reportToHtml-report.xml", (InputStream)new ClassPathResource(this.getResourcePath("output-reportToHtml-report.xml")).getInputStream()).getDocument();
        XmlUtils.assertEquals("text transform", expected, xmldocTransformed.getDocument());
    }

    @Test(expected=XMLException.class)
    public void testTransformUsingDefaultResolverFails() throws Exception {
        XMLDocument xmldoc = XMLDocument.xmldocument((String)"org/wamblee/xml/report.xml", (LSResourceResolver)new ClasspathUriResolver());
        XMLDocument transformed = xmldoc.transform(this.getClass().getResource(REPORT_TO_HTML2_XSLT).toURI());
    }

    @Test(expected=XMLException.class)
    public void testTransformInvalidXslt() throws Exception {
        XMLDocument xmldoc = XMLDocument.xmldocument((String)"org/wamblee/xml/report.xml", (LSResourceResolver)new ClasspathUriResolver());
        XMLDocument transformed = xmldoc.transform(this.getClass().getResource(REPORT_TO_HTML_INVALID_XSLT).toURI());
    }

    @Test(expected=XMLException.class)
    public void testTransformNonWellformedXslt() throws Exception {
        XMLDocument xmldoc = XMLDocument.xmldocument((String)"org/wamblee/xml/report.xml", (LSResourceResolver)new ClasspathUriResolver());
        XMLDocument transformed = xmldoc.transform(this.getClass().getResource(REPORT_TO_HTML_NONWELLFORMED_XSLT).toURI());
    }

    @Test
    public void testTransformUsingClassPathResolver() throws Exception {
        XMLDocument xmldoc = XMLDocument.xmldocument((String)"org/wamblee/xml/report.xml", (LSResourceResolver)new ClasspathUriResolver());
        XMLDocument transformed = xmldoc.transform("org/wamblee/xml/reportToHtml2.xsl", (URIResolver)new ClasspathUriResolver());
        Document output1 = transformed.getDocument();
        Document expected = XMLDocument.xmldocument((URI)this.getClass().getResource("output-reportToHtml-report.xml").toURI()).getDocument();
        XmlUtils.assertEquals("doc", expected, output1);
    }

    @Test
    public void testTransformToTextOutput() throws Exception {
        XMLDocument xmldoc = XMLDocument.xmldocument((String)"org/wamblee/xml/report.xml", (LSResourceResolver)new ClasspathUriResolver());
        String transformed = xmldoc.write((XMLTextProcessor)new XSLTransformation("org/wamblee/xml/reportToText.xsl", (URIResolver)new ClasspathUriResolver()));
        String expected = "Hello world!";
        TestCase.assertEquals((String)"text transform", (String)expected, (String)transformed);
    }

    @Test(expected=XMLException.class)
    public void testResolveWithDefaultResolverFileNotFound() throws Exception {
        XMLDocument xmldoc = XMLDocument.xmldocument((String)"org/wamblee/xml/report.xml", (LSResourceResolver)new ClasspathUriResolver());
        XMLDocument transformed = xmldoc.transform("org/wamblee/xml/utilities-nonexistent.xsl", (URIResolver)new ClasspathUriResolver());
    }
}

