/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class XmlUtils {
    private XmlUtils() {
    }

    public static void assertEquals(String aMsg, Document aExpected, Document aActual) {
        XmlUtils.assertEquals(aMsg + "/" + aExpected.getDocumentElement().getLocalName(), aExpected.getDocumentElement(), aActual.getDocumentElement());
    }

    private static <T> List<T> convertMap(NamedNodeMap aMap, Class<T> aType) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < aMap.getLength(); ++i) {
            result.add(aMap.item(i));
        }
        return result;
    }

    private static List<Element> getChildElements(Element aElement) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList children = aElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            result.add((Element)node);
        }
        return result;
    }

    private static String getDirectText(Element aElement) {
        String res = "";
        NodeList children = aElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Text)) continue;
            res = res + node.getTextContent() + " ";
        }
        return XmlUtils.trim(res);
    }

    private static String trim(String aText) {
        return aText.trim().replaceAll("\\n", " ").replaceAll("\\s+", " ");
    }

    private static void assertEquals(String aMsg, Element aExpected, Element aActual) {
        TestCase.assertEquals((String)(aMsg + "/name()"), (String)aExpected.getLocalName(), (String)aActual.getLocalName());
        TestCase.assertEquals((String)(aMsg + "/namespace()"), (String)aExpected.getNamespaceURI(), (String)aActual.getNamespaceURI());
        TestCase.assertEquals((String)(aMsg + "/text()"), (String)XmlUtils.getDirectText(aExpected), (String)XmlUtils.getDirectText(aActual));
        List<Attr> expectedAttrs = XmlUtils.convertMap(aExpected.getAttributes(), Attr.class);
        Collections.sort(expectedAttrs, new AttributeComparator());
        List<Attr> actualAttrs = XmlUtils.convertMap(aActual.getAttributes(), Attr.class);
        Collections.sort(actualAttrs, new AttributeComparator());
        TestCase.assertEquals((String)("count(" + aMsg + "/@*)"), (int)expectedAttrs.size(), (int)actualAttrs.size());
        for (int i = 0; i < expectedAttrs.size(); ++i) {
            String msg = aMsg + "/@" + expectedAttrs.get(i).getName();
            XmlUtils.assertEquals(msg, expectedAttrs.get(i), actualAttrs.get(i));
        }
        List<Element> expectedElems = XmlUtils.getChildElements(aExpected);
        List<Element> actualElems = XmlUtils.getChildElements(aActual);
        TestCase.assertEquals((String)("count(" + aMsg + "/*)"), (int)expectedElems.size(), (int)actualElems.size());
        TreeMap<String, Integer> elementIndex = new TreeMap<String, Integer>();
        for (int i = 0; i < expectedElems.size(); ++i) {
            String elemName = expectedElems.get(i).getLocalName();
            Integer index = (Integer)elementIndex.get(elemName);
            if (index == null) {
                index = 1;
            } else {
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
            }
            elementIndex.put(elemName, index);
            String msg = aMsg + "/" + expectedElems.get(i).getLocalName() + "[" + index + "]";
            XmlUtils.assertEquals(msg, expectedElems.get(i), actualElems.get(i));
        }
    }

    private static void assertEquals(String aMsg, Attr aExpected, Attr aActual) {
        TestCase.assertEquals((String)(aMsg + ":name"), (String)aExpected.getName(), (String)aActual.getName());
        TestCase.assertEquals((String)(aMsg + ":value"), (String)aExpected.getValue(), (String)aActual.getValue());
    }

    private static final class AttributeComparator
    implements Comparator<Attr>,
    Serializable {
        private static final long serialVersionUID = 7897287273519886301L;

        private AttributeComparator() {
        }

        @Override
        public int compare(Attr aAttribute1, Attr aAttribute2) {
            return aAttribute1.getName().compareTo(aAttribute2.getName());
        }
    }
}

