/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.cache;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wamblee.cache.Cache;

public class CachedObject<KeyType extends Serializable, ValueType extends Serializable> {
    private static final Logger LOGGER = Logger.getLogger(CachedObject.class.getName());
    private Cache<KeyType, ValueType> cache;
    private KeyType objectKey;
    private ValueType value;
    private boolean computing;
    private Computation<KeyType, ValueType> computation;

    public CachedObject(Cache<KeyType, ValueType> aCache, KeyType aObjectKey, Computation<KeyType, ValueType> aComputation) {
        this.cache = aCache;
        this.objectKey = aObjectKey;
        this.computation = aComputation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueType get() {
        CachedObject cachedObject = this;
        synchronized (cachedObject) {
            if (this.computing) {
                return this.value;
            }
            ValueType cachedValue = this.cache.get(this.objectKey);
            if (cachedValue != null) {
                this.value = cachedValue;
                return this.value;
            }
            this.computing = true;
        }
        try {
            LOGGER.fine("Refreshing cache for '" + this.objectKey + "'");
            Object object = this.computation.getObject(this.objectKey);
            this.cache.put(this.objectKey, object);
            CachedObject cachedObject2 = this;
            synchronized (cachedObject2) {
                this.value = object;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Recomputation of cached item failed for key '" + this.objectKey + "'", e);
        }
        finally {
            cachedObject = this;
            synchronized (cachedObject) {
                this.computing = false;
            }
        }
        cachedObject = this;
        synchronized (cachedObject) {
            return this.value;
        }
    }

    public void invalidate() {
        this.cache.remove(this.objectKey);
    }

    public Cache getCache() {
        return this.cache;
    }

    public static interface Computation<Key extends Serializable, Value extends Serializable> {
        public Value getObject(Key var1) throws Exception;
    }
}

