/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.persistence;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Id;
import javax.persistence.Version;
import org.wamblee.persistence.Persistent;
import org.wamblee.reflection.Accessor;
import org.wamblee.reflection.AnnotationUtils;

public class PersistentFactory {
    private static Map<String, EntityAccessor> CACHE = new ConcurrentHashMap<String, EntityAccessor>();

    public static EntityAccessor createEntityAccessor(Class aClass) {
        EntityAccessor accessor = CACHE.get(aClass.getName());
        if (accessor == null && (accessor = PersistentFactory.analyse(aClass)) != null) {
            CACHE.put(aClass.getName(), accessor);
        }
        return accessor;
    }

    private static EntityAccessor analyse(Class aClass) {
        List<Accessor> pkAccessors = AnnotationUtils.analyse(aClass, Id.class);
        List<Accessor> versionAccessors = AnnotationUtils.analyse(aClass, Version.class);
        Accessor pk = null;
        if (pkAccessors.size() > 0) {
            pk = pkAccessors.get(0);
        }
        Accessor version = null;
        if (versionAccessors.size() > 0) {
            version = versionAccessors.get(0);
        }
        if (pk != null || version != null) {
            return new EntityAccessor(pk, version);
        }
        return null;
    }

    public static Persistent create(Object aEntity) {
        EntityAccessor accessor = PersistentFactory.createEntityAccessor(aEntity.getClass());
        if (accessor == null) {
            return null;
        }
        return new EntityObjectAccessor(aEntity, accessor);
    }

    public static class EntityObjectAccessor
    implements Persistent {
        private EntityAccessor accessor;
        private Object entity;

        public EntityObjectAccessor(Object aEntity, EntityAccessor aAccessor) {
            this.accessor = aAccessor;
            this.entity = aEntity;
        }

        public EntityAccessor getAccessor() {
            return this.accessor;
        }

        @Override
        public Serializable getPrimaryKey() {
            if (this.accessor == null || this.accessor.getPk() == null) {
                return null;
            }
            return (Serializable)this.accessor.getPk().get(this.entity);
        }

        @Override
        public void setPrimaryKey(Serializable aKey) {
            if (this.accessor == null || this.accessor.getPk() == null) {
                return;
            }
            this.accessor.getPk().set(this.entity, aKey);
        }

        @Override
        public Number getPersistedVersion() {
            if (this.accessor == null || this.accessor.getVersion() == null) {
                return null;
            }
            return (Number)this.accessor.getVersion().get(this.entity);
        }

        @Override
        public void setPersistedVersion(Number aVersion) {
            if (this.accessor == null || this.accessor.getVersion() == null) {
                return;
            }
            this.accessor.getVersion().set(this.entity, aVersion);
        }
    }

    static class EntityAccessor {
        private Accessor pk;
        private Accessor version;

        public EntityAccessor(Accessor<?> aPk, Accessor<?> aVersion) {
            this.pk = aPk;
            this.version = aVersion;
        }

        public Accessor getPk() {
            return this.pk;
        }

        public Accessor getVersion() {
            return this.version;
        }
    }
}

