/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.reflection;

import java.lang.reflect.Method;
import org.wamblee.reflection.Accessor;

public class PropertyAccessor<T>
implements Accessor<T> {
    private Method getter;
    private Method setter;

    public PropertyAccessor(Method aGetter, Method aSetter) {
        this.getter = aGetter;
        this.setter = aSetter;
        this.getter.setAccessible(true);
        this.setter.setAccessible(true);
    }

    @Override
    public T get(Object aEntity) {
        try {
            return (T)this.getter.invoke(aEntity, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void set(Object aEntity, T aValue) {
        try {
            this.setter.invoke(aEntity, aValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Method getGetter() {
        return this.getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public String toString() {
        return "propertyInjection(" + this.getter + ", " + this.setter + ")";
    }

    @Override
    public Class<T> getType() {
        return this.getter.getReturnType();
    }
}

