/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.xml;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.wamblee.io.ClassPathResource;
import org.wamblee.io.InputResource;
import org.wamblee.xml.DomUtils;

public class ClasspathUriResolver
implements URIResolver,
LSResourceResolver {
    private String base;

    public ClasspathUriResolver() {
        this.base = null;
    }

    public ClasspathUriResolver(String aBase) {
        this.base = aBase;
    }

    @Override
    public Source resolve(String aHref, String aBase) throws TransformerException {
        InputResource xslt = this.resolveImpl(aHref);
        try {
            return new StreamSource(xslt.getInputStream());
        }
        catch (IOException e) {
            throw new TransformerException("Could not get XSLT style sheet in classpath '" + aHref + "'", e);
        }
    }

    private InputResource resolveImpl(String aHref) {
        String systemId = aHref;
        if (this.base != null) {
            systemId = this.base + "/" + aHref;
        }
        ClassPathResource xslt = new ClassPathResource(systemId);
        return xslt;
    }

    @Override
    public LSInput resolveResource(String aType, String aNamespaceURI, String aPublicId, String aSystemId, String aBaseURI) {
        try {
            InputStream xslt = this.resolveImpl(aSystemId).getInputStream();
            DOMImplementationLS impl = DomUtils.getDomImplementationLS();
            LSInput input = impl.createLSInput();
            input.setPublicId(aPublicId);
            input.setSystemId(aSystemId);
            input.setByteStream(xslt);
            return input;
        }
        catch (IOException e) {
            return null;
        }
    }
}

