/*
 * Decompiled with CFR 0.152.
 */
package org.wamblee.xml;

import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;

public final class DomUtils {
    private static final Logger LOG = Logger.getLogger(DomUtils.class.getName());

    private DomUtils() {
    }

    public static DOMImplementationLS getDomImplementationLS() {
        String message = "Could not get Dom level 3 implementation";
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            return impl;
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Could not get Dom level 3 implementation", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not get Dom level 3 implementation", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Could not get Dom level 3 implementation", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not get Dom level 3 implementation", e);
        }
    }

    public static void removeDuplicateAttributes(Node aNode) {
        NodeList list = aNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            if (!(node instanceof Element)) continue;
            DomUtils.removeDuplicateAttributes((Element)node);
            DomUtils.removeDuplicateAttributes(node);
        }
    }

    private static void removeDuplicateAttributes(Element aElement) {
        NamedNodeMap attributes = aElement.getAttributes();
        TreeMap<String, Attr> uniqueAttributes = new TreeMap<String, Attr>();
        ArrayList<Attr> attlist = new ArrayList<Attr>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            if (uniqueAttributes.containsKey(attribute.getNodeName())) {
                LOG.info("Detected duplicate attribute (will be removed)'" + attribute.getNodeName() + "'");
            }
            uniqueAttributes.put(attribute.getNodeName(), attribute);
            attlist.add(attribute);
        }
        for (Attr att : attlist) {
            aElement.removeAttributeNode(att);
        }
        for (Attr att : uniqueAttributes.values()) {
            aElement.setAttributeNode(att);
        }
    }
}

